"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClusterSetupTrust = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var docs = _interopRequireWildcard(require("../../../services/documentation"));
var _app_context = require("../../../app_context");
var _confirm_modal = require("./confirm_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_ALLOWED_VERSION_API_KEYS_METHOD = '8.10';
const CARD_MAX_WIDTH = 400;
const i18nTexts = {
  apiKeyTitle: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithApiKeys.title', {
    defaultMessage: 'API keys'
  }),
  apiKeyDescription: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithApiKeys.description', {
    defaultMessage: 'Fine-grained access to remote indices. You need an API key provided by the remote cluster administrator.'
  }),
  certTitle: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithCert.title', {
    defaultMessage: 'Certificates'
  }),
  certDescription: _i18n.i18n.translate('xpack.remoteClusters.clusterWizard.trustStep.setupWithCert.description', {
    defaultMessage: 'Full access to the remote cluster. You need TLS certificates from the remote cluster.'
  })
};
const docLinks = {
  cert: docs.onPremSetupTrustWithCertUrl,
  apiKey: docs.onPremSetupTrustWithApiKeyUrl,
  cloud: docs.cloudSetupTrustUrl
};
const RemoteClusterSetupTrust = ({
  onBack,
  onSubmit,
  isSaving
}) => {
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const {
    canUseAPIKeyTrustModel,
    isCloudEnabled
  } = (0, _react.useContext)(_app_context.AppContext);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m",
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.title",
    defaultMessage: "Set up an authentication mechanism to connect to the remote cluster. Complete{br} this step using the instructions in our docs before continuing.",
    values: {
      br: /*#__PURE__*/_react.default.createElement("br", null)
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    justifyContent: "center"
  }, canUseAPIKeyTrustModel && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: CARD_MAX_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: i18nTexts.apiKeyTitle,
    paddingSize: "l",
    "data-test-subj": "setupTrustApiKeyCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.apiKeyDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: isCloudEnabled ? docLinks.cloud : docLinks.apiKey,
    target: "_blank",
    "data-test-subj": "setupTrustApiKeyCardDocs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.docs",
    defaultMessage: "View instructions"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.apiKeyNote",
    defaultMessage: "Both clusters must be on version {minAllowedVersion} or above.",
    values: {
      minAllowedVersion: MIN_ALLOWED_VERSION_API_KEYS_METHOD
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: CARD_MAX_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), i18nTexts.certTitle),
    paddingSize: "l",
    "data-test-subj": "setupTrustCertCard"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.certDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: isCloudEnabled ? docLinks.cloud : docLinks.cert,
    target: "_blank",
    "data-test-subj": "setupTrustCertCardDocs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.docs",
    defaultMessage: "View instructions"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: CARD_MAX_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "setupTrustBackButton",
    iconType: "arrowLeft",
    onClick: onBack
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.backButtonLabel",
    defaultMessage: "Back"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      maxWidth: CARD_MAX_WIDTH
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "setupTrustDoneButton",
    color: "primary",
    fill: true,
    isLoading: isSaving,
    onClick: () => setIsModalVisible(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.remoteClusters.clusterWizard.trustStep.doneButtonLabel",
    defaultMessage: "Add remote cluster"
  }))))), isModalVisible && /*#__PURE__*/_react.default.createElement(_confirm_modal.ConfirmTrustSetupModal, {
    closeModal: () => setIsModalVisible(false),
    onSubmit: onSubmit
  })));
};
exports.RemoteClusterSetupTrust = RemoteClusterSetupTrust;