"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionModeCloud = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../services/documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectionModeCloud = props => {
  const {
    fields,
    fieldsErrors,
    areErrorsVisible,
    onFieldsChange
  } = props;
  const {
    cloudRemoteAddress,
    serverName,
    proxySocketConnections,
    cloudAdvancedOptionsEnabled
  } = fields;
  const {
    cloudRemoteAddress: cloudRemoteAddressError
  } = fieldsErrors;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionModeTitle",
      defaultMessage: "Connection mode"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionModeCloudDescription",
      defaultMessage: "Configure how to connect to the remote cluster."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      hasEmptyLabelSpace: true,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.advancedOptionsToggleLabel",
        defaultMessage: "Configure advanced options"
      }),
      checked: cloudAdvancedOptionsEnabled,
      "data-test-subj": "remoteClusterFormCloudAdvancedOptionsToggle",
      onChange: e => onFieldsChange({
        cloudAdvancedOptionsEnabled: e.target.checked
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    })),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormRemoteAddressFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldRemoteAddressLabel",
      defaultMessage: "Remote address"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldRemoteAddressHelpText",
      defaultMessage: "When no port is specified, the default {default_port} port is used.",
      values: {
        default_port: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '9400')
      }
    }),
    isInvalid: Boolean(areErrorsVisible && cloudRemoteAddressError),
    error: cloudRemoteAddressError,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: cloudRemoteAddress,
    placeholder: _i18n.i18n.translate('xpack.remoteClusters.remoteClusterForm.fieldProxyAddressPlaceholder', {
      defaultMessage: 'host:port'
    }),
    onChange: e => onFieldsChange({
      cloudRemoteAddress: e.target.value
    }),
    isInvalid: Boolean(areErrorsVisible && cloudRemoteAddressError),
    "data-test-subj": "remoteClusterFormRemoteAddressInput",
    fullWidth: true
  })), cloudAdvancedOptionsEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormTLSServerNameFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldTLSServerNameLabel",
      defaultMessage: "TLS server name (optional)"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldTLSServerNameHelpText",
      defaultMessage: "If the remote cluster certificate has a different server name, specify it here. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.proxySettingsUrl,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.remoteClusters.remoteClusterForm.fieldTLSServerNameHelpText.learnMoreLinkLabel",
          defaultMessage: "Learn more."
        }))
      }
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: serverName,
    onChange: e => onFieldsChange({
      serverName: e.target.value
    }),
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "remoteClusterFormProxySocketConnectionsFormRow",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldProxySocketConnectionsLabel",
      defaultMessage: "Socket connections"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.fieldSocketConnectionsHelpText",
      defaultMessage: "The number of connections to open per remote cluster."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: proxySocketConnections || '',
    onChange: e => onFieldsChange({
      proxySocketConnections: Number(e.target.value)
    }),
    fullWidth: true
  }))));
};
exports.ConnectionModeCloud = ConnectionModeCloud;