"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectionMode = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _app_context = require("../../../../app_context");
var _connection_mode_cloud = require("./connection_mode_cloud");
var _sniff_connection = require("./sniff_connection");
var _proxy_connection = require("./proxy_connection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectionMode = props => {
  const {
    fields,
    onFieldsChange
  } = props;
  const {
    mode
  } = fields;
  const {
    isCloudEnabled
  } = (0, _app_context.useAppContext)();
  return isCloudEnabled ? /*#__PURE__*/_react.default.createElement(_connection_mode_cloud.ConnectionModeCloud, props) : /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionModeTitle",
      defaultMessage: "Connection mode"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.remoteClusters.remoteClusterForm.sectionModeDescription",
      defaultMessage: "Use seed nodes by default, or switch to proxy mode."
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      hasEmptyLabelSpace: true,
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.remoteClusters.remoteClusterForm.fieldModeLabel",
        defaultMessage: "Use proxy mode"
      }),
      checked: mode === _constants.PROXY_MODE,
      "data-test-subj": "remoteClusterFormConnectionModeToggle",
      onChange: e => onFieldsChange({
        mode: e.target.checked ? _constants.PROXY_MODE : _constants.SNIFF_MODE
      })
    })))),
    fullWidth: true
  }, mode === _constants.SNIFF_MODE ? /*#__PURE__*/_react.default.createElement(_sniff_connection.SniffConnection, props) : /*#__PURE__*/_react.default.createElement(_proxy_connection.ProxyConnection, props));
};
exports.ConnectionMode = ConnectionMode;