"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationUtilPlugin = void 0;
var _plugin_services = require("./services/plugin_services");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class PresentationUtilPlugin {
  setup(_coreSetup, _setupPlugins) {
    return {};
  }
  start(coreStart, startPlugins) {
    _plugin_services.pluginServices.setRegistry(_plugin_services.registry.start({
      coreStart,
      startPlugins
    }));
    return {
      ContextProvider: _plugin_services.pluginServices.getContextProvider(),
      labsService: _plugin_services.pluginServices.getServices().labs,
      registerExpressionsLanguage: _.registerExpressionsLanguage
    };
  }
  stop() {}
}
exports.PresentationUtilPlugin = PresentationUtilPlugin;