"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FloatingActions = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _services = require("../../services");
require("./floating_actions.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FloatingActions = ({
  children,
  viewMode,
  isEnabled,
  embeddable,
  className = '',
  disabledActions
}) => {
  const {
    uiActions: {
      getTriggerCompatibleActions
    }
  } = _services.pluginServices.getServices();
  const [floatingActions, setFloatingActions] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    if (!embeddable) return;
    const getActions = async () => {
      let mounted = true;
      const context = {
        embeddable,
        trigger: _public.panelHoverTrigger
      };
      const actions = (await getTriggerCompatibleActions(_public.PANEL_HOVER_TRIGGER, context)).filter(action => {
        return action.MenuItem !== undefined && (disabledActions !== null && disabledActions !== void 0 ? disabledActions : []).indexOf(action.id) === -1;
      }).sort((a, b) => (a.order || 0) - (b.order || 0));
      if (!mounted) return;
      if (actions.length > 0) {
        setFloatingActions( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actions.map(action => /*#__PURE__*/_react.default.createElement(action.MenuItem, {
          key: action.id,
          context
        }))));
      } else {
        setFloatingActions(undefined);
      }
      return () => {
        mounted = false;
      };
    };
    getActions();
  }, [embeddable, getTriggerCompatibleActions, viewMode, disabledActions]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "presentationUtil__floatingActionsWrapper"
  }, children, isEnabled && floatingActions && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `presentationUtil__floatingActions__${embeddable === null || embeddable === void 0 ? void 0 : embeddable.id}`,
    className: (0, _classnames.default)('presentationUtil__floatingActions', className)
  }, floatingActions));
};
exports.FloatingActions = FloatingActions;