"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.waitFor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactTestRenderer = require("react-test-renderer");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const waitFor = (waitTarget, spinner = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)) => CurrentStory => {
  const [storyComponent, setStory] = (0, _react.useState)();
  const componentIsMounted = (0, _react.useRef)(false);
  (0, _react.useEffect)(() => {
    componentIsMounted.current = true;
    return () => {
      componentIsMounted.current = false;
    };
  }, []);
  (0, _react.useEffect)(() => {
    if (!storyComponent) {
      waitTarget.then(waitedTarget => {
        if (!componentIsMounted.current) return;
        (0, _reactTestRenderer.act)(() => {
          setStory( /*#__PURE__*/_react.default.createElement(CurrentStory, waitedTarget));
        });
      });
    }
  }, [CurrentStory, storyComponent]);
  return storyComponent !== null && storyComponent !== void 0 ? storyComponent : spinner;
};
exports.waitFor = waitFor;