"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.placeholderTitle = exports.getErrorLoadingPanel = exports.getErrorCallToAction = exports.getEditTitleAriaLabel = exports.getContextMenuAriaLabel = exports.getAriaLabelForTitle = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const placeholderTitle = exports.placeholderTitle = _i18n.i18n.translate('presentationPanel.placeholderTitle', {
  defaultMessage: '[No Title]'
});
const getAriaLabelForTitle = title => {
  if (title) {
    return _i18n.i18n.translate('presentationPanel.enhancedAriaLabel', {
      defaultMessage: 'Panel: {title}',
      values: {
        title: title || placeholderTitle
      }
    });
  }
  return _i18n.i18n.translate('presentationPanel.ariaLabel', {
    defaultMessage: 'Panel'
  });
};
exports.getAriaLabelForTitle = getAriaLabelForTitle;
const getErrorCallToAction = title => _i18n.i18n.translate('presentationPanel.error.editButton', {
  defaultMessage: 'Edit {value}',
  values: {
    value: title
  }
});
exports.getErrorCallToAction = getErrorCallToAction;
const getErrorLoadingPanel = () => _i18n.i18n.translate('presentationPanel.error.errorWhenLoadingPanel', {
  defaultMessage: 'An error occurred while loading this panel.'
});
exports.getErrorLoadingPanel = getErrorLoadingPanel;
const getEditTitleAriaLabel = title => _i18n.i18n.translate('presentationPanel.header.titleAriaLabel', {
  defaultMessage: 'Click to edit title: {title}',
  values: {
    title: title || placeholderTitle
  }
});
exports.getEditTitleAriaLabel = getEditTitleAriaLabel;
const getContextMenuAriaLabel = (title, index) => {
  if (title) {
    return _i18n.i18n.translate('presentationPanel.contextMenu.ariaLabelWithTitle', {
      defaultMessage: 'Panel options for {title}',
      values: {
        title
      }
    });
  }
  if (index) {
    return _i18n.i18n.translate('presentationPanel.contextMenu.ariaLabelWithIndex', {
      defaultMessage: 'Options for panel {index}',
      values: {
        index
      }
    });
  }
  return _i18n.i18n.translate('presentationPanel.contextMenu.ariaLabel', {
    defaultMessage: 'Panel options'
  });
};
exports.getContextMenuAriaLabel = getContextMenuAriaLabel;