"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelInternal = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _panelLoader = require("@kbn/panel-loader");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _presentation_panel_header = require("./panel_header/presentation_panel_header");
var _presentation_panel_error = require("./presentation_panel_error");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PresentationPanelInternal = ({
  index,
  hideHeader,
  showShadow,
  showBorder,
  showBadges,
  showNotifications,
  getActions,
  actionPredicate,
  Component,
  componentProps,
  onPanelStatusChange
}) => {
  var _api$parentApi;
  const [api, setApi] = (0, _react.useState)(null);
  const headerId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const viewModeSubject = (() => {
    if ((0, _presentationPublishing.apiPublishesViewMode)(api)) return api.viewMode;
    if ((0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationPublishing.apiPublishesViewMode)(api.parentApi)) return api.parentApi.viewMode;
  })();
  const [dataLoading, blockingError, panelTitle, hidePanelTitle, panelDescription, defaultPanelTitle, defaultPanelDescription, rawViewMode, parentHidePanelTitle] = (0, _presentationPublishing.useBatchedOptionalPublishingSubjects)(api === null || api === void 0 ? void 0 : api.dataLoading, api === null || api === void 0 ? void 0 : api.blockingError, api === null || api === void 0 ? void 0 : api.panelTitle, api === null || api === void 0 ? void 0 : api.hidePanelTitle, api === null || api === void 0 ? void 0 : api.panelDescription, api === null || api === void 0 ? void 0 : api.defaultPanelTitle, api === null || api === void 0 ? void 0 : api.defaultPanelDescription, viewModeSubject, api === null || api === void 0 ? void 0 : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.hidePanelTitle);
  const viewMode = rawViewMode !== null && rawViewMode !== void 0 ? rawViewMode : 'view';
  const [initialLoadComplete, setInitialLoadComplete] = (0, _react.useState)(!dataLoading);
  if (!initialLoadComplete && (dataLoading === false || api && !api.dataLoading)) {
    setInitialLoadComplete(true);
  }
  const hideTitle = Boolean(hidePanelTitle) || Boolean(parentHidePanelTitle) || viewMode === 'view' && !Boolean(panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle);
  (0, _react.useEffect)(() => {
    let subscription;
    if (api && onPanelStatusChange && (0, _presentationPublishing.apiPublishesPhaseEvents)(api)) {
      subscription = api.onPhaseChange.subscribe(phase => {
        if (phase) onPanelStatusChange(phase);
      });
    }
    return () => {
      var _subscription;
      return (_subscription = subscription) === null || _subscription === void 0 ? void 0 : _subscription.unsubscribe();
    };
  }, [api, onPanelStatusChange]);
  const contentAttrs = (0, _react.useMemo)(() => {
    const attrs = {};
    if (dataLoading) {
      attrs['data-loading'] = true;
    } else {
      attrs['data-render-complete'] = true;
    }
    if (blockingError) attrs['data-error'] = true;
    return attrs;
  }, [dataLoading, blockingError]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    role: "figure",
    paddingSize: "none",
    className: (0, _classnames.default)('embPanel', {
      'embPanel--editing': viewMode === 'edit'
    }),
    hasShadow: showShadow,
    hasBorder: showBorder,
    "aria-labelledby": headerId,
    "data-test-embeddable-id": api === null || api === void 0 ? void 0 : api.uuid,
    "data-test-subj": "embeddablePanel"
  }, contentAttrs), !hideHeader && api && /*#__PURE__*/_react.default.createElement(_presentation_panel_header.PresentationPanelHeader, {
    api: api,
    index: index,
    headerId: headerId,
    viewMode: viewMode,
    hideTitle: hideTitle,
    showBadges: showBadges,
    getActions: getActions,
    actionPredicate: actionPredicate,
    showNotifications: showNotifications,
    panelTitle: panelTitle !== null && panelTitle !== void 0 ? panelTitle : defaultPanelTitle,
    panelDescription: panelDescription !== null && panelDescription !== void 0 ? panelDescription : defaultPanelDescription
  }), blockingError && api && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    className: "eui-fullHeight embPanel__error",
    "data-test-subj": "embeddableError",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_presentation_panel_error.PresentationPanelError, {
    api: api,
    error: blockingError
  })), !initialLoadComplete && /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, null), /*#__PURE__*/_react.default.createElement("div", {
    className: blockingError ? 'embPanel__content--hidden' : 'embPanel__content'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, componentProps, {
    ref: newApi => {
      if (newApi && !api) setApi(newApi);
    }
  })))));
};
exports.PresentationPanelInternal = PresentationPanelInternal;