"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PresentationPanelError = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _searchErrors = require("@kbn/search-errors");
var _sharedUxMarkdown = require("@kbn/shared-ux-markdown");
var _rxjs = require("rxjs");
var _panel_actions = require("../panel_actions/panel_actions");
var _presentation_panel_strings = require("./presentation_panel_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PresentationPanelError = ({
  api,
  error
}) => {
  var _searchErrorDisplay$a, _searchErrorDisplay$b;
  const [isEditable, setIsEditable] = (0, _react.useState)(false);
  const handleErrorClick = (0, _react.useMemo)(() => isEditable ? () => _panel_actions.editPanelAction === null || _panel_actions.editPanelAction === void 0 ? void 0 : _panel_actions.editPanelAction.execute({
    embeddable: api
  }) : undefined, [api, isEditable]);
  const label = (0, _react.useMemo)(() => isEditable ? _panel_actions.editPanelAction === null || _panel_actions.editPanelAction === void 0 ? void 0 : _panel_actions.editPanelAction.getDisplayName({
    embeddable: api
  }) : '', [api, isEditable]);
  const panelTitle = (0, _presentationPublishing.useStateFromPublishingSubject)(api === null || api === void 0 ? void 0 : api.panelTitle);
  const ariaLabel = (0, _react.useMemo)(() => panelTitle ? (0, _presentation_panel_strings.getErrorCallToAction)(panelTitle) : label, [label, panelTitle]);

  // Get initial editable state from action and subscribe to changes.
  (0, _react.useEffect)(() => {
    if (!(_panel_actions.editPanelAction !== null && _panel_actions.editPanelAction !== void 0 && _panel_actions.editPanelAction.couldBecomeCompatible({
      embeddable: api
    }))) return;
    let canceled = false;
    const subscription = new _rxjs.Subscription();
    (async () => {
      const initiallyCompatible = await (_panel_actions.editPanelAction === null || _panel_actions.editPanelAction === void 0 ? void 0 : _panel_actions.editPanelAction.isCompatible({
        embeddable: api
      }));
      if (canceled) return;
      setIsEditable(initiallyCompatible);
      subscription.add(_panel_actions.editPanelAction === null || _panel_actions.editPanelAction === void 0 ? void 0 : _panel_actions.editPanelAction.subscribeToCompatibilityChanges({
        embeddable: api
      }, isCompatible => {
        if (!canceled) setIsEditable(isCompatible);
      }));
    })();
    return () => {
      canceled = true;
      subscription.unsubscribe();
    };
  }, [api]);
  const searchErrorDisplay = (0, _searchErrors.renderSearchError)(error);
  const actions = (_searchErrorDisplay$a = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.actions) !== null && _searchErrorDisplay$a !== void 0 ? _searchErrorDisplay$a : [];
  if (isEditable) {
    actions.push( /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": ariaLabel,
      onClick: handleErrorClick,
      size: "s"
    }, label));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: (_searchErrorDisplay$b = searchErrorDisplay === null || searchErrorDisplay === void 0 ? void 0 : searchErrorDisplay.body) !== null && _searchErrorDisplay$b !== void 0 ? _searchErrorDisplay$b : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_sharedUxMarkdown.Markdown, {
      "data-test-subj": "errorMessageMarkdown",
      readOnly: true
    }, error.message)),
    "data-test-subj": "embeddableStackError",
    iconType: "warning",
    iconColor: "danger",
    layout: "vertical",
    actions: actions
  });
};
exports.PresentationPanelError = PresentationPanelError;