"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePresentationPanelHeaderActions = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _kibana_services = require("../../kibana_services");
var _panel_actions = require("../../panel_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const usePresentationPanelHeaderActions = (showNotifications, showBadges, api, getActions) => {
  const [badges, setBadges] = (0, _react.useState)([]);
  const [notifications, setNotifications] = (0, _react.useState)([]);

  /**
   * Get all actions once on mount of the panel. Any actions that are Frequent Compatibility
   * Change Actions need to be subscribed to so they can change over the lifetime of this panel.
   */
  (0, _react.useEffect)(() => {
    let canceled = false;
    const subscriptions = new _rxjs.Subscription();
    const getTriggerCompatibleActions = getActions !== null && getActions !== void 0 ? getActions : _kibana_services.uiActions.getTriggerCompatibleActions;
    const getActionsForTrigger = async triggerId => {
      var _ref, _api$disabledActionId;
      let nextActions = (_ref = await getTriggerCompatibleActions(triggerId, {
        embeddable: api
      })) !== null && _ref !== void 0 ? _ref : [];
      const disabledActions = (_api$disabledActionId = api.disabledActionIds) === null || _api$disabledActionId === void 0 ? void 0 : _api$disabledActionId.value;
      if (disabledActions) {
        nextActions = nextActions.filter(badge => disabledActions.indexOf(badge.id) === -1);
      }
      return nextActions;
    };
    const handleActionCompatibilityChange = (type, isCompatible, action) => {
      if (canceled) return;
      (type === 'badge' ? setBadges : setNotifications)(currentActions => {
        const newActions = currentActions === null || currentActions === void 0 ? void 0 : currentActions.filter(current => current.id !== action.id);
        if (isCompatible) return [...newActions, action];
        return newActions;
      });
    };
    (async () => {
      const [initialBadges, initialNotifications] = await Promise.all([getActionsForTrigger(_panel_actions.PANEL_BADGE_TRIGGER), getActionsForTrigger(_panel_actions.PANEL_NOTIFICATION_TRIGGER)]);
      if (canceled) return;
      setBadges(initialBadges);
      setNotifications(initialNotifications);
      const apiContext = {
        embeddable: api
      };

      // subscribe to any frequently changing badge actions
      const frequentlyChangingBadges = _kibana_services.uiActions.getFrequentlyChangingActionsForTrigger(_panel_actions.PANEL_BADGE_TRIGGER, apiContext);
      for (const badge of frequentlyChangingBadges) {
        subscriptions.add(badge.subscribeToCompatibilityChanges(apiContext, (isComptaible, action) => handleActionCompatibilityChange('badge', isComptaible, action)));
      }

      // subscribe to any frequently changing notification actions
      const frequentlyChangingNotifications = _kibana_services.uiActions.getFrequentlyChangingActionsForTrigger(_panel_actions.PANEL_NOTIFICATION_TRIGGER, apiContext);
      for (const notification of frequentlyChangingNotifications) {
        subscriptions.add(notification.subscribeToCompatibilityChanges(apiContext, (isComptaible, action) => handleActionCompatibilityChange('notification', isComptaible, action)));
      }
    })();
    return () => {
      canceled = true;
      subscriptions.unsubscribe();
    };
    // Disable exhaustive deps because this is meant to be run once on mount.
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const badgeElements = (0, _react.useMemo)(() => {
    if (!showBadges) return [];
    return badges === null || badges === void 0 ? void 0 : badges.map(badge => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      key: badge.id,
      className: "embPanel__headerBadge",
      iconType: badge.getIconType({
        embeddable: api,
        trigger: _panel_actions.panelBadgeTrigger
      }),
      onClick: () => badge.execute({
        embeddable: api,
        trigger: _panel_actions.panelBadgeTrigger
      }),
      onClickAriaLabel: badge.getDisplayName({
        embeddable: api,
        trigger: _panel_actions.panelBadgeTrigger
      }),
      "data-test-subj": `embeddablePanelBadge-${badge.id}`
    }, badge.getDisplayName({
      embeddable: api,
      trigger: _panel_actions.panelBadgeTrigger
    })));
  }, [api, badges, showBadges]);
  const notificationElements = (0, _react.useMemo)(() => {
    if (!showNotifications) return [];
    return notifications === null || notifications === void 0 ? void 0 : notifications.map(notification => {
      let notificationComponent = notification.MenuItem ? ( /*#__PURE__*/_react.default.createElement(notification.MenuItem, {
        key: notification.id,
        context: {
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        }
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
        "data-test-subj": `embeddablePanelNotification-${notification.id}`,
        key: notification.id,
        style: {
          marginTop: _uiTheme.euiThemeVars.euiSizeXS,
          marginRight: _uiTheme.euiThemeVars.euiSizeXS
        },
        onClick: () => notification.execute({
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        })
      }, notification.getDisplayName({
        embeddable: api,
        trigger: _panel_actions.panelNotificationTrigger
      }));
      if (notification.getDisplayNameTooltip) {
        const tooltip = notification.getDisplayNameTooltip({
          embeddable: api,
          trigger: _panel_actions.panelNotificationTrigger
        });
        if (tooltip) {
          notificationComponent = /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            position: "top",
            delay: "regular",
            content: tooltip,
            key: notification.id
          }, notificationComponent);
        }
      }
      return notificationComponent;
    });
  }, [api, notifications, showNotifications]);
  return {
    badgeElements,
    notificationElements
  };
};
exports.usePresentationPanelHeaderActions = usePresentationPanelHeaderActions;