"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.panelNotificationTrigger = exports.panelHoverTrigger = exports.panelBadgeTrigger = exports.contextMenuTrigger = exports.PANEL_NOTIFICATION_TRIGGER = exports.PANEL_HOVER_TRIGGER = exports.PANEL_BADGE_TRIGGER = exports.CONTEXT_MENU_TRIGGER = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONTEXT_MENU_TRIGGER = exports.CONTEXT_MENU_TRIGGER = 'CONTEXT_MENU_TRIGGER';
const contextMenuTrigger = exports.contextMenuTrigger = {
  id: CONTEXT_MENU_TRIGGER,
  title: _i18n.i18n.translate('presentationPanel.contextMenuTrigger.title', {
    defaultMessage: 'Context menu'
  }),
  description: _i18n.i18n.translate('presentationPanel.contextMenuTrigger.description', {
    defaultMessage: "A new action will be added to the panel's context menu"
  })
};
const PANEL_HOVER_TRIGGER = exports.PANEL_HOVER_TRIGGER = 'PANEL_HOVER_TRIGGER';
const panelHoverTrigger = exports.panelHoverTrigger = {
  id: PANEL_HOVER_TRIGGER,
  title: _i18n.i18n.translate('presentationPanel.hoverTrigger.title', {
    defaultMessage: 'Panel hover'
  }),
  description: _i18n.i18n.translate('presentationPanel.hoverTrigger.description', {
    defaultMessage: "A new action will be added to the panel's hover menu"
  })
};
const PANEL_BADGE_TRIGGER = exports.PANEL_BADGE_TRIGGER = 'PANEL_BADGE_TRIGGER';
const panelBadgeTrigger = exports.panelBadgeTrigger = {
  id: PANEL_BADGE_TRIGGER,
  title: _i18n.i18n.translate('presentationPanel.badgeTrigger.title', {
    defaultMessage: 'Panel badges'
  }),
  description: _i18n.i18n.translate('presentationPanel.badgeTrigger.description', {
    defaultMessage: 'Badge actions appear in title bar when an embeddable loads in a panel.'
  })
};
const PANEL_NOTIFICATION_TRIGGER = exports.PANEL_NOTIFICATION_TRIGGER = 'PANEL_NOTIFICATION_TRIGGER';
const panelNotificationTrigger = exports.panelNotificationTrigger = {
  id: PANEL_NOTIFICATION_TRIGGER,
  title: _i18n.i18n.translate('presentationPanel.notificationTrigger.title', {
    defaultMessage: 'Panel notifications'
  }),
  description: _i18n.i18n.translate('presentationPanel.notificationTrigger.description', {
    defaultMessage: 'Notification actions appear in top-right corner of a panel.'
  })
};