"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerActions = exports.getEditPanelAction = exports.editPanelAction = exports.customizePanelAction = void 0;
var _kibana_services = require("../kibana_services");
var _customize_panel_action = require("./customize_panel_action");
var _edit_panel_action = require("./edit_panel_action/edit_panel_action");
var _inspect_panel_action = require("./inspect_panel_action/inspect_panel_action");
var _remove_panel_action = require("./remove_panel_action/remove_panel_action");
var _triggers = require("./triggers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// export these actions to make them accessible in this plugin.
let customizePanelAction = exports.customizePanelAction = void 0;
let editPanelAction = exports.editPanelAction = void 0;
const getEditPanelAction = () => editPanelAction;
exports.getEditPanelAction = getEditPanelAction;
const registerActions = () => {
  exports.editPanelAction = editPanelAction = new _edit_panel_action.EditPanelAction();
  exports.customizePanelAction = customizePanelAction = new _customize_panel_action.CustomizePanelAction();
  const removePanel = new _remove_panel_action.RemovePanelAction();
  const inspectPanel = new _inspect_panel_action.InspectPanelAction();
  const timeRangeBadge = new _customize_panel_action.CustomTimeRangeBadge();
  _kibana_services.uiActions.registerAction(removePanel);
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, removePanel.id);
  _kibana_services.uiActions.registerAction(timeRangeBadge);
  _kibana_services.uiActions.attachAction(_triggers.PANEL_BADGE_TRIGGER, timeRangeBadge.id);
  _kibana_services.uiActions.registerAction(inspectPanel);
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, inspectPanel.id);
  _kibana_services.uiActions.registerAction(editPanelAction);
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, editPanelAction.id);
  _kibana_services.uiActions.registerAction(customizePanelAction);
  _kibana_services.uiActions.attachAction(_triggers.CONTEXT_MENU_TRIGGER, customizePanelAction.id);
};
exports.registerActions = registerActions;