"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectPanelAction = exports.ACTION_INSPECT_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/inspector-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public2 = require("@kbn/ui-actions-plugin/public");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_INSPECT_PANEL = exports.ACTION_INSPECT_PANEL = 'openInspector';
const isApiCompatible = api => {
  return Boolean(api) && (0, _public.apiHasInspectorAdapters)(api);
};
class InspectPanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_INSPECT_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_INSPECT_PANEL);
    (0, _defineProperty2.default)(this, "order", 20);
  }
  getDisplayName() {
    return _i18n.i18n.translate('presentationPanel.action.inspectPanel.displayName', {
      defaultMessage: 'Inspect'
    });
  }
  getIconType() {
    return 'inspect';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) return false;
    return _kibana_services.inspector.isAvailable(embeddable.getInspectorAdapters());
  }
  async execute({
    embeddable
  }) {
    var _embeddable$parentApi;
    if (!isApiCompatible(embeddable)) throw new _public2.IncompatibleActionError();
    const adapters = embeddable.getInspectorAdapters();
    if (!(await this.isCompatible({
      embeddable
    })) || adapters === undefined) {
      throw new _public2.IncompatibleActionError();
    }
    const panelTitle = (0, _presentationPublishing.getPanelTitle)(embeddable) || _i18n.i18n.translate('presentationPanel.action.inspectPanel.untitledEmbeddableFilename', {
      defaultMessage: 'untitled'
    });
    const session = _kibana_services.inspector.open(adapters, {
      title: panelTitle,
      options: {
        fileName: panelTitle
      }
    });
    session.onClose.finally(() => {
      if ((0, _presentationContainers.tracksOverlays)(embeddable.parentApi)) embeddable.parentApi.clearOverlays();
    });

    // send the overlay ref to the parent API if it is capable of tracking overlays
    if ((0, _presentationContainers.tracksOverlays)(embeddable.parentApi)) (_embeddable$parentApi = embeddable.parentApi) === null || _embeddable$parentApi === void 0 ? void 0 : _embeddable$parentApi.openOverlay(session);
  }
}
exports.InspectPanelAction = InspectPanelAction;