"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPanelAction = exports.ACTION_EDIT_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EDIT_PANEL = exports.ACTION_EDIT_PANEL = 'editPanel';
const isApiCompatible = api => {
  return (0, _presentationPublishing.hasEditCapabilities)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api);
};
class EditPanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_EDIT_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_EDIT_PANEL);
    (0, _defineProperty2.default)(this, "order", 50);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _i18n.i18n.translate('presentationPanel.action.editPanel.displayName', {
      defaultMessage: 'Edit {value}',
      values: {
        value: embeddable.getTypeDisplayName()
      }
    });
  }
  subscribeToCompatibilityChanges({
    embeddable
  }, onChange) {
    var _getViewModeSubject;
    if (!isApiCompatible(embeddable)) return;
    return (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(embeddable)) === null || _getViewModeSubject === void 0 ? void 0 : _getViewModeSubject.subscribe(viewMode => {
      if (viewMode === 'edit' && isApiCompatible(embeddable) && embeddable.isEditingEnabled()) {
        onChange(true, this);
        return;
      }
      onChange(false, this);
    });
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return isApiCompatible(embeddable);
  }
  getIconType() {
    return 'pencil';
  }
  async getHref({
    embeddable
  }) {
    var _embeddable$getEditHr;
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return embeddable === null || embeddable === void 0 ? void 0 : (_embeddable$getEditHr = embeddable.getEditHref) === null || _embeddable$getEditHr === void 0 ? void 0 : _embeddable$getEditHr.call(embeddable);
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable) || !embeddable.isEditingEnabled()) return false;
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit';
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    embeddable.onEdit();
  }
}
exports.EditPanelAction = EditPanelAction;