"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomizePanelEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/data-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../../kibana_services");
var _filters_details = require("./filters_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CustomizePanelEditor = ({
  api,
  onClose,
  focusOnTitle
}) => {
  var _api$hidePanelTitle, _api$panelDescription, _api$panelDescription2, _api$defaultPanelDesc, _api$timeRange$$value, _api$timeRange$, _api$parentApi, _api$parentApi$timeRa, _api$timeRange$2;
  /**
   * eventually the panel editor could be made to use state from the API instead (which will allow us to use a push flyout)
   * For now, we copy the state here with `useState` initializing it to the latest value.
   */
  const editMode = (0, _presentationPublishing.getInheritedViewMode)(api) === 'edit';
  const [hideTitle, setHideTitle] = (0, _react.useState)((_api$hidePanelTitle = api.hidePanelTitle) === null || _api$hidePanelTitle === void 0 ? void 0 : _api$hidePanelTitle.value);
  const [panelDescription, setPanelDescription] = (0, _react.useState)((_api$panelDescription = (_api$panelDescription2 = api.panelDescription) === null || _api$panelDescription2 === void 0 ? void 0 : _api$panelDescription2.value) !== null && _api$panelDescription !== void 0 ? _api$panelDescription : (_api$defaultPanelDesc = api.defaultPanelDescription) === null || _api$defaultPanelDesc === void 0 ? void 0 : _api$defaultPanelDesc.value);
  const [panelTitle, setPanelTitle] = (0, _react.useState)((0, _presentationPublishing.getPanelTitle)(api));
  const [timeRange, setTimeRange] = (0, _react.useState)((_api$timeRange$$value = (_api$timeRange$ = api.timeRange$) === null || _api$timeRange$ === void 0 ? void 0 : _api$timeRange$.value) !== null && _api$timeRange$$value !== void 0 ? _api$timeRange$$value : (_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : (_api$parentApi$timeRa = _api$parentApi.timeRange$) === null || _api$parentApi$timeRa === void 0 ? void 0 : _api$parentApi$timeRa.value);
  const initialFocusRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (focusOnTitle && initialFocusRef.current) {
      initialFocusRef.current.focus();
    }
  }, [initialFocusRef, focusOnTitle]);
  const [hasOwnTimeRange, setHasOwnTimeRange] = (0, _react.useState)(Boolean((_api$timeRange$2 = api.timeRange$) === null || _api$timeRange$2 === void 0 ? void 0 : _api$timeRange$2.value));
  const commonlyUsedRangesForDatePicker = (0, _react.useMemo)(() => {
    const commonlyUsedRanges = _kibana_services.core.uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
    if (!commonlyUsedRanges) return [];
    return commonlyUsedRanges.map(({
      from,
      to,
      display
    }) => {
      return {
        start: from,
        end: to,
        label: display
      };
    });
  }, []);
  const dateFormat = (0, _react.useMemo)(() => _kibana_services.core.uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT), []);
  const save = () => {
    var _api$panelTitle, _api$setPanelTitle, _api$hidePanelTitle2, _api$setHidePanelTitl, _api$panelDescription3, _api$setPanelDescript, _api$timeRange$3;
    if (panelTitle !== ((_api$panelTitle = api.panelTitle) === null || _api$panelTitle === void 0 ? void 0 : _api$panelTitle.value)) (_api$setPanelTitle = api.setPanelTitle) === null || _api$setPanelTitle === void 0 ? void 0 : _api$setPanelTitle.call(api, panelTitle);
    if (hideTitle !== ((_api$hidePanelTitle2 = api.hidePanelTitle) === null || _api$hidePanelTitle2 === void 0 ? void 0 : _api$hidePanelTitle2.value)) (_api$setHidePanelTitl = api.setHidePanelTitle) === null || _api$setHidePanelTitl === void 0 ? void 0 : _api$setHidePanelTitl.call(api, hideTitle);
    if (panelDescription !== ((_api$panelDescription3 = api.panelDescription) === null || _api$panelDescription3 === void 0 ? void 0 : _api$panelDescription3.value)) (_api$setPanelDescript = api.setPanelDescription) === null || _api$setPanelDescript === void 0 ? void 0 : _api$setPanelDescript.call(api, panelDescription);
    const newTimeRange = hasOwnTimeRange ? timeRange : undefined;
    if (newTimeRange !== ((_api$timeRange$3 = api.timeRange$) === null || _api$timeRange$3 === void 0 ? void 0 : _api$timeRange$3.value)) {
      var _api$setTimeRange;
      (_api$setTimeRange = api.setTimeRange) === null || _api$setTimeRange === void 0 ? void 0 : _api$setTimeRange.call(api, newTimeRange);
    }
    onClose();
  };
  const renderCustomTitleComponent = () => {
    var _api$defaultPanelTitl2, _api$defaultPanelDesc3;
    if (!editMode) return null;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "customEmbeddableTitleComponent"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      checked: !hideTitle,
      "data-test-subj": "customEmbeddablePanelHideTitleSwitch",
      disabled: !editMode,
      id: "hideTitle",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Show title",
        id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.showTitle"
      }),
      onChange: e => setHideTitle(!e.target.checked)
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.panelTitleFormRowLabel",
        defaultMessage: "Title"
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "resetCustomEmbeddablePanelTitleButton",
        onClick: () => {
          var _api$defaultPanelTitl;
          return setPanelTitle((_api$defaultPanelTitl = api.defaultPanelTitle) === null || _api$defaultPanelTitl === void 0 ? void 0 : _api$defaultPanelTitl.value);
        },
        disabled: hideTitle || !editMode || (api === null || api === void 0 ? void 0 : (_api$defaultPanelTitl2 = api.defaultPanelTitle) === null || _api$defaultPanelTitl2 === void 0 ? void 0 : _api$defaultPanelTitl2.value) === panelTitle,
        "aria-label": _i18n.i18n.translate('presentationPanel.action.customizePanel.flyout.optionsMenuForm.resetCustomTitleButtonAriaLabel', {
          defaultMessage: 'Reset title'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.resetCustomTitleButtonLabel",
        defaultMessage: "Reset"
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      inputRef: initialFocusRef,
      id: "panelTitleInput",
      className: "panelTitleInputText",
      "data-test-subj": "customEmbeddablePanelTitleInput",
      name: "title",
      type: "text",
      disabled: hideTitle || !editMode,
      value: panelTitle !== null && panelTitle !== void 0 ? panelTitle : '',
      onChange: e => setPanelTitle(e.target.value),
      "aria-label": _i18n.i18n.translate('presentationPanel.action.customizePanel.flyout.optionsMenuForm.panelTitleInputAriaLabel', {
        defaultMessage: 'Enter a custom title for your panel'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.panelDescriptionFormRowLabel",
        defaultMessage: "Description"
      }),
      labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        "data-test-subj": "resetCustomEmbeddablePanelDescriptionButton",
        onClick: () => {
          var _api$defaultPanelDesc2;
          return setPanelDescription((_api$defaultPanelDesc2 = api.defaultPanelDescription) === null || _api$defaultPanelDesc2 === void 0 ? void 0 : _api$defaultPanelDesc2.value);
        },
        disabled: !editMode || ((_api$defaultPanelDesc3 = api.defaultPanelDescription) === null || _api$defaultPanelDesc3 === void 0 ? void 0 : _api$defaultPanelDesc3.value) === panelDescription,
        "aria-label": _i18n.i18n.translate('presentationPanel.action.customizePanel.flyout.optionsMenuForm.resetCustomDescriptionButtonAriaLabel', {
          defaultMessage: 'Reset description'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationPanel.action.customizePanel.modal.optionsMenuForm.resetCustomDescriptionButtonLabel",
        defaultMessage: "Reset"
      }))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      id: "panelDescriptionInput",
      className: "panelDescriptionInputText",
      "data-test-subj": "customEmbeddablePanelDescriptionInput",
      disabled: !editMode,
      name: "description",
      value: panelDescription !== null && panelDescription !== void 0 ? panelDescription : '',
      onChange: e => setPanelDescription(e.target.value),
      "aria-label": _i18n.i18n.translate('presentationPanel.action.customizePanel.flyout.optionsMenuForm.panelDescriptionAriaLabel', {
        defaultMessage: 'Enter a custom description for your panel'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  };
  const renderCustomTimeRangeComponent = () => {
    var _isCompatibleWithUnif, _isCompatibleWithUnif2, _ref, _timeRange$from, _timeRange$to;
    if (!(0, _presentationPublishing.apiPublishesTimeRange)(api) || !((_isCompatibleWithUnif = (_isCompatibleWithUnif2 = (_ref = api).isCompatibleWithUnifiedSearch) === null || _isCompatibleWithUnif2 === void 0 ? void 0 : _isCompatibleWithUnif2.call(_ref)) !== null && _isCompatibleWithUnif !== void 0 ? _isCompatibleWithUnif : true)) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      checked: hasOwnTimeRange,
      "data-test-subj": "customizePanelShowCustomTimeRange",
      id: "showCustomTimeRange",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Apply custom time range",
        id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.showCustomTimeRangeSwitch"
      }),
      onChange: e => setHasOwnTimeRange(e.target.checked)
    })), hasOwnTimeRange ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "presentationPanel.action.customizePanel.flyout.optionsMenuForm.panelTimeRangeFormRowLabel",
        defaultMessage: "Time range"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
      start: (_timeRange$from = timeRange === null || timeRange === void 0 ? void 0 : timeRange.from) !== null && _timeRange$from !== void 0 ? _timeRange$from : undefined,
      end: (_timeRange$to = timeRange === null || timeRange === void 0 ? void 0 : timeRange.to) !== null && _timeRange$to !== void 0 ? _timeRange$to : undefined,
      onTimeChange: ({
        start,
        end
      }) => setTimeRange({
        from: start,
        to: end
      }),
      showUpdateButton: false,
      dateFormat: dateFormat,
      commonlyUsedRanges: commonlyUsedRangesForDatePicker,
      "data-test-subj": "customizePanelTimeRangeDatePicker"
    })) : null);
  };
  const renderFilterDetails = () => {
    if (!(0, _presentationPublishing.apiPublishesUnifiedSearch)(api)) return null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_filters_details.FiltersDetails, {
      editMode: editMode,
      api: api
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "presentationPanel.action.customizePanel.flyout.title",
    defaultMessage: "Settings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": "customizePanelForm"
  }, renderCustomTitleComponent(), renderCustomTimeRangeComponent(), renderFilterDetails())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelCustomizePanelButton",
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "presentationPanel.action.customizePanel.flyout.cancelButtonTitle",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "saveCustomizePanelButton",
    onClick: save,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "presentationPanel.action.customizePanel.flyout.saveButtonTitle",
    defaultMessage: "Apply"
  }))))));
};
exports.CustomizePanelEditor = CustomizePanelEditor;