"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApiCompatibleWithCustomizePanelAction = exports.CustomizePanelAction = exports.ACTION_CUSTOMIZE_PANEL = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _open_customize_panel = require("./open_customize_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_CUSTOMIZE_PANEL = exports.ACTION_CUSTOMIZE_PANEL = 'ACTION_CUSTOMIZE_PANEL';
const isApiCompatibleWithCustomizePanelAction = api => (0, _presentationPublishing.apiCanAccessViewMode)(api) && ((0, _presentationPublishing.apiPublishesDataViews)(api) || (0, _presentationPublishing.apiPublishesPanelTitle)(api));
exports.isApiCompatibleWithCustomizePanelAction = isApiCompatibleWithCustomizePanelAction;
class CustomizePanelAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", ACTION_CUSTOMIZE_PANEL);
    (0, _defineProperty2.default)(this, "id", ACTION_CUSTOMIZE_PANEL);
    (0, _defineProperty2.default)(this, "order", 45);
  }
  getDisplayName({
    embeddable
  }) {
    return _i18n.i18n.translate('presentationPanel.action.customizePanel.displayName', {
      defaultMessage: 'Settings'
    });
  }
  getIconType() {
    return 'gear';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$isCompati, _embeddable$isCompati2;
    if (!isApiCompatibleWithCustomizePanelAction(embeddable)) return false;
    // It should be possible to customize just the time range in View mode
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' || (0, _presentationPublishing.apiPublishesUnifiedSearch)(embeddable) && ((_embeddable$isCompati = (_embeddable$isCompati2 = embeddable.isCompatibleWithUnifiedSearch) === null || _embeddable$isCompati2 === void 0 ? void 0 : _embeddable$isCompati2.call(embeddable)) !== null && _embeddable$isCompati !== void 0 ? _embeddable$isCompati : true);
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatibleWithCustomizePanelAction(embeddable)) throw new _public.IncompatibleActionError();
    (0, _open_customize_panel.openCustomizePanelFlyout)({
      api: embeddable
    });
  }
}
exports.CustomizePanelAction = CustomizePanelAction;