"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTimeRangeBadge = exports.CUSTOM_TIME_RANGE_BADGE = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/ui-actions-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _server = require("react-dom/server");
var _common = require("@kbn/data-plugin/common");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _kibana_services = require("../../kibana_services");
var _panel_actions = require("../panel_actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CUSTOM_TIME_RANGE_BADGE = exports.CUSTOM_TIME_RANGE_BADGE = 'CUSTOM_TIME_RANGE_BADGE';
class CustomTimeRangeBadge {
  constructor() {
    (0, _defineProperty2.default)(this, "type", CUSTOM_TIME_RANGE_BADGE);
    (0, _defineProperty2.default)(this, "id", CUSTOM_TIME_RANGE_BADGE);
    (0, _defineProperty2.default)(this, "order", 7);
  }
  getDisplayName({
    embeddable
  }) {
    var _core$uiSettings$get;
    if (!(0, _presentationPublishing.apiPublishesTimeRange)(embeddable)) throw new _public.IncompatibleActionError();
    const timeRange = embeddable.timeRange$.value;
    if (!timeRange) return '';
    return (0, _server.renderToString)( /*#__PURE__*/_react.default.createElement(_eui.PrettyDuration, {
      timeTo: timeRange.to,
      timeFrom: timeRange.from,
      dateFormat: (_core$uiSettings$get = _kibana_services.core.uiSettings.get(_common.UI_SETTINGS.DATE_FORMAT)) !== null && _core$uiSettings$get !== void 0 ? _core$uiSettings$get : 'Browser'
    }));
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return (0, _presentationPublishing.apiPublishesTimeRange)(embeddable);
  }
  subscribeToCompatibilityChanges({
    embeddable
  }, onChange) {
    if (!(0, _presentationPublishing.apiPublishesTimeRange)(embeddable)) return;
    return embeddable.timeRange$.subscribe(timeRange => {
      onChange(Boolean(timeRange), this);
    });
  }
  async execute({
    embeddable
  }) {
    _panel_actions.customizePanelAction.execute({
      embeddable
    });
  }
  getIconType() {
    return 'calendar';
  }
  async isCompatible({
    embeddable
  }) {
    if ((0, _presentationPublishing.apiPublishesTimeRange)(embeddable)) {
      const timeRange = embeddable.timeRange$.value;
      return Boolean(timeRange);
    }
    return false;
  }
}
exports.CustomTimeRangeBadge = CustomTimeRangeBadge;