"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usageCollection = exports.untilPluginStartServicesReady = exports.uiActions = exports.setKibanaServices = exports.savedObjectsTaggingOss = exports.savedObjectsManagement = exports.inspector = exports.core = exports.contentManagement = void 0;
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let core = exports.core = void 0;
let uiActions = exports.uiActions = void 0;
let inspector = exports.inspector = void 0;
let usageCollection = exports.usageCollection = void 0;
let savedObjectsManagement = exports.savedObjectsManagement = void 0;
let savedObjectsTaggingOss = exports.savedObjectsTaggingOss = void 0;
let contentManagement = exports.contentManagement = void 0;
const servicesReady$ = new _rxjs.BehaviorSubject(false);
const untilPluginStartServicesReady = () => {
  if (servicesReady$.value) return Promise.resolve();
  return new Promise(resolve => {
    const subscription = servicesReady$.subscribe(isInitialized => {
      if (isInitialized) {
        subscription.unsubscribe();
        resolve();
      }
    });
  });
};
exports.untilPluginStartServicesReady = untilPluginStartServicesReady;
const setKibanaServices = (kibanaCore, deps) => {
  exports.core = core = kibanaCore;
  exports.uiActions = uiActions = deps.uiActions;
  exports.inspector = inspector = deps.inspector;
  exports.usageCollection = usageCollection = deps.usageCollection;
  exports.contentManagement = contentManagement = deps.contentManagement;
  exports.savedObjectsManagement = savedObjectsManagement = deps.savedObjectsManagement;
  exports.savedObjectsTaggingOss = savedObjectsTaggingOss = deps.savedObjectsTaggingOss;
  servicesReady$.next(true);
};
exports.setKibanaServices = setKibanaServices;