"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedQueryFlyout = void 0;
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_saved_query_form = require("./form/use_saved_query_form");
var _form = require("./form");
var _use_create_saved_query = require("./use_create_saved_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SavedQueryFlyoutComponent = ({
  defaultValue,
  onClose
}) => {
  const createSavedQueryMutation = (0, _use_create_saved_query.useCreateSavedQuery)({
    withRedirect: false
  });
  const hooksForm = (0, _use_saved_query_form.useSavedQueryForm)({
    defaultValue
  });
  const {
    serializer,
    idSet,
    handleSubmit,
    formState: {
      isSubmitting
    }
  } = hooksForm;
  const onSubmit = (0, _react.useCallback)(async payload => {
    const serializedData = serializer(payload);
    await createSavedQueryMutation.mutateAsync(serializedData).then(() => onClose());
  }, [createSavedQueryMutation, onClose, serializer]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();

  // we need this flyout to be above the timeline flyout (which has a z-index of 1002)
  const maskProps = (0, _react.useMemo)(() => ({
    style: `z-index: ${euiTheme.levels.flyout + 3}`
  }), [euiTheme.levels.flyout]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": 'osquery-save-query-flyout',
    size: "m",
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": "flyoutTitle",
    maskProps: maskProps
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.savedQuery.saveQueryFlyoutForm.addFormTitle",
    defaultMessage: "Save query"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, hooksForm, /*#__PURE__*/_react.default.createElement(_form.SavedQueryForm, {
    idSet: idSet
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onClose,
    flush: "left"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "savedQueryFlyoutSaveButton",
    isLoading: isSubmitting,
    onClick: handleSubmit(onSubmit),
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.osquery.pack.queryFlyoutForm.saveButtonLabel",
    defaultMessage: "Save"
  })))))));
};
const SavedQueryFlyout = exports.SavedQueryFlyout = /*#__PURE__*/_react.default.memo(SavedQueryFlyoutComponent);