"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.packConfigFilesValidator = exports.configProtectedKeysValidator = exports.OsqueryManagedPolicyCreateImportExtension = void 0;
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
var _satisfies = _interopRequireDefault(require("semver/functions/satisfies"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _immer = require("immer");
var _i18n = require("@kbn/i18n");
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _common = require("@kbn/fleet-plugin/common");
var _public = require("@kbn/fleet-plugin/public");
var _common2 = require("../../common");
var _kibana = require("../common/lib/kibana");
var _navigation_buttons = require("./navigation_buttons");
var _disabled_callout = require("./disabled_callout");
var _config_uploader = require("./config_uploader");
var _shared_imports = require("../shared_imports");
var _use_fetch_status = require("./use_fetch_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// https://github.com/elastic/beats/blob/master/x-pack/osquerybeat/internal/osqd/args.go#L57
const RESTRICTED_CONFIG_OPTIONS = ['force', 'disable_watchdog', 'utc', 'events_expiry', 'extensions_socket', 'extensions_interval', 'extensions_timeout', 'pidfile', 'database_path', 'extensions_autoload', 'flagfile', 'config_plugin', 'logger_plugin', 'pack_delimiter', 'config_refresh'];
const configProtectedKeysValidator = (...args) => {
  var _configJSON$options, _configJSON;
  const [{
    value
  }] = args;
  let configJSON;
  try {
    configJSON = JSON.parse(value);
  } catch (e) {
    return;
  }
  const restrictedFlags = (0, _lodash.intersection)(Object.keys((_configJSON$options = (_configJSON = configJSON) === null || _configJSON === void 0 ? void 0 : _configJSON.options) !== null && _configJSON$options !== void 0 ? _configJSON$options : {}), RESTRICTED_CONFIG_OPTIONS);
  if (restrictedFlags.length) {
    return {
      code: 'ERR_RESTRICTED_OPTIONS',
      message: _i18n.i18n.translate('xpack.osquery.fleetIntegration.osqueryConfig.restrictedOptionsErrorMessage', {
        defaultMessage: 'The following osquery options are not supported and must be removed: {restrictedFlags}.',
        values: {
          restrictedFlags: restrictedFlags.join(', ')
        }
      })
    };
  }
  return;
};
exports.configProtectedKeysValidator = configProtectedKeysValidator;
const packConfigFilesValidator = (...args) => {
  var _configJSON$packs, _configJSON2;
  const [{
    value
  }] = args;
  let configJSON;
  try {
    configJSON = JSON.parse(value);
  } catch (e) {
    return;
  }
  const packsWithConfigPaths = Object.keys((0, _lodash.pickBy)((_configJSON$packs = (_configJSON2 = configJSON) === null || _configJSON2 === void 0 ? void 0 : _configJSON2.packs) !== null && _configJSON$packs !== void 0 ? _configJSON$packs : {}, _lodash.isString));
  if (packsWithConfigPaths.length) {
    return {
      code: 'ERR_RESTRICTED_OPTIONS',
      message: _i18n.i18n.translate('xpack.osquery.fleetIntegration.osqueryConfig.packConfigFilesErrorMessage', {
        defaultMessage: 'Pack configuration files are not supported. These packs must be removed: {packNames}.',
        values: {
          packNames: packsWithConfigPaths.join(', ')
        }
      })
    };
  }
  return;
};
exports.packConfigFilesValidator = packConfigFilesValidator;
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});

/**
 * Exports Osquery-specific package policy instructions
 * for use in the Fleet app create / edit package policy
 */

const OsqueryManagedPolicyCreateImportExtension = exports.OsqueryManagedPolicyCreateImportExtension = /*#__PURE__*/_react.default.memo(({
  onChange,
  policy,
  newPolicy
}) => {
  var _agentPolicy$name;
  const [policyAgentsCount, setPolicyAgentsCount] = (0, _react.useState)(null);
  const [agentPolicy, setAgentPolicy] = (0, _react.useState)(null);
  const [editMode] = (0, _react.useState)(!!policy);
  const {
    application: {
      getUrlForApp
    },
    http
  } = (0, _kibana.useKibana)().services;
  const {
    form: configForm
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      config: JSON.stringify((0, _lodash.get)(newPolicy, 'inputs[0].config.osquery.value', {}), null, 2)
    },
    schema: {
      config: {
        label: _i18n.i18n.translate('xpack.osquery.fleetIntegration.osqueryConfig.configFieldLabel', {
          defaultMessage: 'Osquery config'
        }),
        type: _shared_imports.FIELD_TYPES.JSON,
        validations: [{
          validator: _shared_imports.fieldValidators.isJsonField(_i18n.i18n.translate('xpack.osquery.fleetIntegration.osqueryConfig.configFieldError', {
            defaultMessage: 'Invalid JSON'
          }), {
            allowEmptyString: true
          })
        }, {
          validator: packConfigFilesValidator
        }, {
          validator: configProtectedKeysValidator
        }]
      }
    }
  });
  const [{
    config
  }] = (0, _shared_imports.useFormData)({
    form: configForm,
    watch: 'config'
  });
  const {
    isValid,
    setFieldValue
  } = configForm;
  const agentsLinkHref = (0, _react.useMemo)(() => {
    if (!(policy !== null && policy !== void 0 && policy.policy_id)) return '#';
    return getUrlForApp(_common.PLUGIN_ID, {
      path: _public.pagePathGetters.policy_details({
        policyId: policy === null || policy === void 0 ? void 0 : policy.policy_id
      })[1]
    });
  }, [getUrlForApp, policy === null || policy === void 0 ? void 0 : policy.policy_id]);
  const handleConfigUpload = (0, _react.useCallback)(newConfig => {
    let currentPacks = {};
    try {
      var _JSON$parse;
      currentPacks = (_JSON$parse = JSON.parse(config)) === null || _JSON$parse === void 0 ? void 0 : _JSON$parse.packs;
      // eslint-disable-next-line no-empty
    } catch (e) {}
    if (newConfig) {
      setFieldValue('config', JSON.stringify({
        ...newConfig,
        ...(currentPacks || newConfig.packs ? {
          packs: {
            ...newConfig.packs,
            ...currentPacks
          }
        } : {})
      }, null, 2));
    }
  }, [config, setFieldValue]);
  (0, _useDebounce.default)(() => {
    // if undefined it means that config was not modified
    if (isValid === undefined) return;
    const updatedPolicy = (0, _immer.produce)(newPolicy, draft => {
      let parsedConfig;
      try {
        parsedConfig = JSON.parse(config);
        // eslint-disable-next-line no-empty
      } catch (e) {}
      if ((0, _lodash.isEmpty)(parsedConfig)) {
        (0, _lodash.unset)(draft, 'inputs[0].config');
      } else {
        (0, _saferLodashSet.set)(draft, 'inputs[0].config.osquery.value', parsedConfig);
      }
      return draft;
    });
    onChange({
      isValid: !!isValid,
      updatedPolicy: isValid ? updatedPolicy : newPolicy
    });
  }, 500, [isValid, config]);
  (0, _react.useEffect)(() => {
    if (editMode && policyAgentsCount === null) {
      const fetchAgentsCount = async () => {
        try {
          const response = await http.fetch(_common.agentRouteService.getStatusPath(), {
            query: {
              policyId: policy === null || policy === void 0 ? void 0 : policy.policy_id
            }
          });
          if (response.results) {
            setPolicyAgentsCount(response.results.total);
          }
          // eslint-disable-next-line no-empty
        } catch (e) {}
      };
      const fetchAgentPolicyDetails = async () => {
        if (policy !== null && policy !== void 0 && policy.policy_id) {
          try {
            const response = await http.fetch(_common.agentPolicyRouteService.getInfoPath(policy === null || policy === void 0 ? void 0 : policy.policy_id));
            if (response.item) {
              setAgentPolicy(response.item);
            }
            // eslint-disable-next-line no-empty
          } catch (e) {}
        }
      };
      fetchAgentsCount();
      fetchAgentPolicyDetails();
    }
  }, [editMode, http, policy === null || policy === void 0 ? void 0 : policy.policy_id, policyAgentsCount]);
  (0, _react.useEffect)(() => {
    var _newPolicy$package;
    /*
      by default Fleet set up streams with an empty scheduled query,
      this code removes that, so the user can schedule queries
      in the next step
    */

    const policyVersion = newPolicy === null || newPolicy === void 0 ? void 0 : (_newPolicy$package = newPolicy.package) === null || _newPolicy$package === void 0 ? void 0 : _newPolicy$package.version;
    if (policyVersion) {
      /* From 0.6.0 we don't provide an input template, so we have to set it here */
      const versionWithoutTemplate = (0, _satisfies.default)(policyVersion, '>=0.6.0');
      if (!editMode && !versionWithoutTemplate) {
        const updatedPolicy = (0, _immer.produce)(newPolicy, draft => {
          (0, _saferLodashSet.set)(draft, 'inputs[0].streams', []);
        });
        onChange({
          isValid: true,
          updatedPolicy
        });
      }
      if (versionWithoutTemplate) {
        const updatedPolicy = (0, _immer.produce)(newPolicy, draft => {
          var _newPolicy$inputs$, _newPolicy$inputs$$st;
          const hasNewInputs = (_newPolicy$inputs$ = newPolicy.inputs[0]) === null || _newPolicy$inputs$ === void 0 ? void 0 : (_newPolicy$inputs$$st = _newPolicy$inputs$.streams) === null || _newPolicy$inputs$$st === void 0 ? void 0 : _newPolicy$inputs$$st.length;
          // 1.12.0 introduces multiple streams
          const versionWithStreams = (0, _satisfies.default)(policyVersion, '>=1.12.0');
          if (versionWithStreams && hasNewInputs) {
            return draft;
          }
          if (editMode && policy !== null && policy !== void 0 && policy.inputs.length) {
            (0, _saferLodashSet.set)(draft, 'inputs', policy.inputs);
          } else {
            (0, _saferLodashSet.set)(draft, 'inputs[0]', {
              type: 'osquery',
              enabled: true,
              streams: [],
              policy_template: _common2.OSQUERY_INTEGRATION_NAME
            });
          }
          return draft;
        });
        if (updatedPolicy !== null && updatedPolicy !== void 0 && updatedPolicy.inputs[0].config) {
          setFieldValue('config', JSON.stringify(updatedPolicy === null || updatedPolicy === void 0 ? void 0 : updatedPolicy.inputs[0].config.osquery.value, null, 2));
        }
        onChange({
          isValid: true,
          updatedPolicy
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const {
    permissionDenied
  } = (0, _use_fetch_status.useFetchStatus)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const euiAccordionCss = (0, _react.useMemo)(() => ({
    '.euiAccordion__button': {
      color: euiTheme.colors.primary
    }
  }), [euiTheme]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !editMode ? /*#__PURE__*/_react.default.createElement(_disabled_callout.DisabledCallout, null) : null, policyAgentsCount === 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: "No agents in the policy",
    color: "warning",
    iconType: "help"
  }, /*#__PURE__*/_react.default.createElement("p", null, `Fleet has detected that you have not assigned yet any agent to the `, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: agentsLinkHref
  }, (_agentPolicy$name = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.name) !== null && _agentPolicy$name !== void 0 ? _agentPolicy$name : policy === null || policy === void 0 ? void 0 : policy.policy_id), `. `, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("strong", null, `Only agents within the policy with active Osquery Manager integration support the functionality presented below.`))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, !permissionDenied && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_navigation_buttons.NavigationButtons, {
    isDisabled: !editMode,
    agentPolicyId: policy === null || policy === void 0 ? void 0 : policy.policy_id
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    css: euiAccordionCss,
    id: "advanced",
    buttonContent: _i18n.i18n.translate('xpack.osquery.fleetIntegration.osqueryConfig.accordionFieldLabel', {
      defaultMessage: 'Advanced'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: configForm
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "config"
  }), /*#__PURE__*/_react.default.createElement(_config_uploader.ConfigUploader, {
    onChange: handleConfigUpload
  })))));
});
OsqueryManagedPolicyCreateImportExtension.displayName = 'OsqueryManagedPolicyCreateImportExtension';