"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VersionOrUndefined = exports.Version = exports.StringArrayOrUndefined = exports.SortOrderOrUndefined = exports.SortOrUndefined = exports.SnapshotOrUndefined = exports.Snapshot = exports.Shards = exports.SavedQueryIdOrUndefined = exports.SavedQueryId = exports.RemovedOrUndefined = exports.Removed = exports.QueryOrUndefined = exports.Query = exports.QueriesOrUndefined = exports.Queries = exports.PolicyIdsOrUndefined = exports.PolicyIds = exports.PlatformOrUndefined = exports.Platform = exports.PageSizeOrUndefined = exports.PageOrUndefined = exports.PackName = exports.PackIdOrUndefined = exports.PackId = exports.ObjectQueriesItem = exports.ObjectQueries = exports.KueryOrUndefined = exports.IntervalOrUndefined = exports.Interval = exports.IdOrUndefined = exports.Id = exports.ExecutionContextOrUndefined = exports.ExecutionContext = exports.EnabledOrUndefined = exports.Enabled = exports.ECSMappingOrUndefined = exports.ECSMappingItem = exports.ECSMapping = exports.DescriptionOrUndefined = exports.Description = exports.ArrayQueriesItem = exports.ArrayQueries = exports.AgentSelectionOrUndefined = exports.AgentSelection = void 0;
var _zod = require("zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Common Osquery Attributes
 *   version: 2023-10-31
 */

const Id = exports.Id = _zod.z.string();
const IdOrUndefined = exports.IdOrUndefined = Id.nullable();
const AgentSelection = exports.AgentSelection = _zod.z.object({
  agents: _zod.z.array(_zod.z.string()).optional(),
  allAgentsSelected: _zod.z.boolean().optional(),
  platformsSelected: _zod.z.array(_zod.z.string()).optional(),
  policiesSelected: _zod.z.array(_zod.z.string()).optional()
});
const AgentSelectionOrUndefined = exports.AgentSelectionOrUndefined = AgentSelection.nullable();
const Description = exports.Description = _zod.z.string();
const DescriptionOrUndefined = exports.DescriptionOrUndefined = Description.nullable();
const Platform = exports.Platform = _zod.z.string();
const PlatformOrUndefined = exports.PlatformOrUndefined = Platform.nullable();
const Query = exports.Query = _zod.z.string();
const QueryOrUndefined = exports.QueryOrUndefined = Query.nullable();
const Version = exports.Version = _zod.z.string();
const VersionOrUndefined = exports.VersionOrUndefined = Version.nullable();
const Interval = exports.Interval = _zod.z.string();
const IntervalOrUndefined = exports.IntervalOrUndefined = Interval.nullable();
const Snapshot = exports.Snapshot = _zod.z.boolean();
const SnapshotOrUndefined = exports.SnapshotOrUndefined = Snapshot.nullable();
const Removed = exports.Removed = _zod.z.boolean();
const RemovedOrUndefined = exports.RemovedOrUndefined = Removed.nullable();
const PackName = exports.PackName = _zod.z.string();
const SavedQueryId = exports.SavedQueryId = _zod.z.string();
const SavedQueryIdOrUndefined = exports.SavedQueryIdOrUndefined = SavedQueryId.nullable();
const PackId = exports.PackId = _zod.z.string();
const PackIdOrUndefined = exports.PackIdOrUndefined = PackId.nullable();
const Enabled = exports.Enabled = _zod.z.boolean();
const EnabledOrUndefined = exports.EnabledOrUndefined = Enabled.nullable();
const PolicyIds = exports.PolicyIds = _zod.z.array(_zod.z.string());
const PolicyIdsOrUndefined = exports.PolicyIdsOrUndefined = PolicyIds.nullable();
const ExecutionContext = exports.ExecutionContext = _zod.z.object({
  name: _zod.z.string().nullable().optional(),
  url: _zod.z.string().nullable().optional()
});
const ExecutionContextOrUndefined = exports.ExecutionContextOrUndefined = ExecutionContext.nullable();
const ECSMappingItem = exports.ECSMappingItem = _zod.z.object({
  field: _zod.z.string().optional(),
  value: _zod.z.union([_zod.z.string(), _zod.z.array(_zod.z.string())]).optional()
});
const ECSMapping = exports.ECSMapping = _zod.z.object({}).catchall(ECSMappingItem);
const ECSMappingOrUndefined = exports.ECSMappingOrUndefined = ECSMapping.nullable();
const StringArrayOrUndefined = exports.StringArrayOrUndefined = _zod.z.array(_zod.z.string().nullable());
const ArrayQueriesItem = exports.ArrayQueriesItem = _zod.z.object({
  id: Id.optional(),
  query: Query.optional(),
  ecs_mapping: ECSMappingOrUndefined.optional(),
  version: VersionOrUndefined.optional(),
  platform: PlatformOrUndefined.optional(),
  removed: RemovedOrUndefined.optional(),
  snapshot: SnapshotOrUndefined.optional()
});
const ArrayQueries = exports.ArrayQueries = _zod.z.array(ArrayQueriesItem);
const ObjectQueriesItem = exports.ObjectQueriesItem = _zod.z.object({
  query: Query.optional(),
  id: Id.optional(),
  ecs_mapping: ECSMappingOrUndefined.optional(),
  version: VersionOrUndefined.optional(),
  platform: PlatformOrUndefined.optional(),
  saved_query_id: SavedQueryIdOrUndefined.optional(),
  removed: RemovedOrUndefined.optional(),
  snapshot: SnapshotOrUndefined.optional()
});
const ObjectQueries = exports.ObjectQueries = _zod.z.object({}).catchall(ObjectQueriesItem);
const Queries = exports.Queries = _zod.z.union([ArrayQueries, ObjectQueries]);
const QueriesOrUndefined = exports.QueriesOrUndefined = Queries.nullable();
const KueryOrUndefined = exports.KueryOrUndefined = _zod.z.string().nullable();
const PageOrUndefined = exports.PageOrUndefined = _zod.z.number().int().nullable();
const PageSizeOrUndefined = exports.PageSizeOrUndefined = _zod.z.number().int().nullable();
const SortOrUndefined = exports.SortOrUndefined = _zod.z.string().nullable();
const SortOrderOrUndefined = exports.SortOrderOrUndefined = _zod.z.union([_zod.z.string().nullable(), _zod.z.unknown()]);
const Shards = exports.Shards = _zod.z.object({}).catchall(_zod.z.number());