"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilitySharedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _page_template = require("./components/page_template");
var _navigation_registry = require("./components/page_template/helpers/navigation_registry");
var _asset_details_flyout_locator = require("./locators/infra/asset_details_flyout_locator");
var _asset_details_locator = require("./locators/infra/asset_details_locator");
var _hosts_locator = require("./locators/infra/hosts_locator");
var _flamegraph_locator = require("./locators/profiling/flamegraph_locator");
var _stacktraces_locator = require("./locators/profiling/stacktraces_locator");
var _topn_functions_locator = require("./locators/profiling/topn_functions_locator");
var _service_overview_locator = require("./locators/apm/service_overview_locator");
var _update_global_navigation = require("./services/update_global_navigation");
var _transaction_details_by_name_locator = require("./locators/apm/transaction_details_by_name_locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilitySharedPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "navigationRegistry", (0, _navigation_registry.createNavigationRegistry)());
    (0, _defineProperty2.default)(this, "isSidebarEnabled$", void 0);
    this.isSidebarEnabled$ = new _rxjs.BehaviorSubject(true);
  }
  setup(coreSetup, pluginsSetup) {
    coreSetup.getStartServices().then(([coreStart]) => {
      coreStart.chrome.getChromeStyle$().subscribe(style => this.isSidebarEnabled$.next(style === 'classic'));
    });
    return {
      locators: this.createLocators(pluginsSetup.share.url),
      navigation: {
        registerSections: this.navigationRegistry.registerSections
      }
    };
  }
  start(core, plugins) {
    var _plugins$guidedOnboar;
    const {
      application
    } = core;
    const PageTemplate = (0, _page_template.createLazyObservabilityPageTemplate)({
      currentAppId$: application.currentAppId$,
      getUrlForApp: application.getUrlForApp,
      navigateToApp: application.navigateToApp,
      navigationSections$: this.navigationRegistry.sections$,
      guidedOnboardingApi: (_plugins$guidedOnboar = plugins.guidedOnboarding) === null || _plugins$guidedOnboar === void 0 ? void 0 : _plugins$guidedOnboar.guidedOnboardingApi,
      getPageTemplateServices: () => ({
        coreStart: core
      }),
      isSidebarEnabled$: this.isSidebarEnabled$
    });
    return {
      locators: this.createLocators(plugins.share.url),
      navigation: {
        PageTemplate,
        registerSections: this.navigationRegistry.registerSections
      },
      updateGlobalNavigation: _update_global_navigation.updateGlobalNavigation
    };
  }
  stop() {}
  createLocators(urlService) {
    return {
      infra: {
        assetDetailsLocator: urlService.locators.create(new _asset_details_locator.AssetDetailsLocatorDefinition()),
        assetDetailsFlyoutLocator: urlService.locators.create(new _asset_details_flyout_locator.AssetDetailsFlyoutLocatorDefinition()),
        hostsLocator: urlService.locators.create(new _hosts_locator.HostsLocatorDefinition())
      },
      profiling: {
        flamegraphLocator: urlService.locators.create(new _flamegraph_locator.FlamegraphLocatorDefinition()),
        topNFunctionsLocator: urlService.locators.create(new _topn_functions_locator.TopNFunctionsLocatorDefinition()),
        stacktracesLocator: urlService.locators.create(new _stacktraces_locator.StacktracesLocatorDefinition())
      },
      apm: {
        serviceOverview: urlService.locators.create(new _service_overview_locator.ServiceOverviewLocatorDefinition()),
        transactionDetailsByName: urlService.locators.create(new _transaction_details_by_name_locator.TransactionDetailsByNameLocatorDefinition())
      }
    };
  }
}
exports.ObservabilitySharedPlugin = ObservabilitySharedPlugin;