"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewLocatorDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _queryString = _interopRequireDefault(require("query-string"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ServiceOverviewLocatorDefinition {
  constructor() {
    (0, _defineProperty2.default)(this, "id", 'serviceOverviewLocator');
    (0, _defineProperty2.default)(this, "getLocation", async ({
      rangeFrom,
      rangeTo,
      serviceName
    }) => {
      const params = {
        rangeFrom,
        rangeTo
      };
      return {
        app: 'apm',
        path: `/services/${serviceName}/overview?${_queryString.default.stringify(params)}`,
        state: {}
      };
    });
  }
}
exports.ServiceOverviewLocatorDefinition = ServiceOverviewLocatorDefinition;