"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_query_params = require("./use_query_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function addClickHandlers(breadcrumbs, navigateToHref) {
  return breadcrumbs.map(bc => ({
    ...bc,
    ...(bc.href ? {
      onClick: event => {
        if (navigateToHref && bc.href) {
          event.preventDefault();
          navigateToHref(bc.href);
        }
      }
    } : {})
  }));
}
function getTitleFromBreadCrumbs(breadcrumbs) {
  return breadcrumbs.map(({
    text
  }) => {
    var _text$toString;
    return (_text$toString = text === null || text === void 0 ? void 0 : text.toString()) !== null && _text$toString !== void 0 ? _text$toString : '';
  }).reverse();
}
const useBreadcrumbs = (extraCrumbs, app, breadcrumbsAppendExtension) => {
  var _getUrlForApp, _app$id;
  const params = (0, _use_query_params.useQueryParams)();
  const {
    services: {
      chrome: {
        docTitle,
        setBreadcrumbs,
        setBreadcrumbsAppendExtension
      },
      application: {
        getUrlForApp,
        navigateToUrl
      }
    }
  } = (0, _public.useKibana)();
  const setTitle = docTitle.change;
  const appPath = (_getUrlForApp = getUrlForApp((_app$id = app === null || app === void 0 ? void 0 : app.id) !== null && _app$id !== void 0 ? _app$id : 'observability-overview')) !== null && _getUrlForApp !== void 0 ? _getUrlForApp : '';
  (0, _react.useEffect)(() => {
    if (breadcrumbsAppendExtension) {
      setBreadcrumbsAppendExtension(breadcrumbsAppendExtension);
    }
    return () => {
      if (breadcrumbsAppendExtension) {
        setBreadcrumbsAppendExtension(undefined);
      }
    };
  }, [breadcrumbsAppendExtension, setBreadcrumbsAppendExtension]);
  (0, _react.useEffect)(() => {
    var _app$label;
    const breadcrumbs = [{
      text: (_app$label = app === null || app === void 0 ? void 0 : app.label) !== null && _app$label !== void 0 ? _app$label : _i18n.i18n.translate('xpack.observabilityShared.breadcrumbs.observabilityLinkText', {
        defaultMessage: 'Observability'
      }),
      href: appPath + '/overview'
    }, ...extraCrumbs];
    if (setBreadcrumbs) {
      setBreadcrumbs(addClickHandlers(breadcrumbs, navigateToUrl));
    }
    if (setTitle) {
      setTitle(getTitleFromBreadCrumbs(breadcrumbs));
    }
  }, [app === null || app === void 0 ? void 0 : app.label, appPath, extraCrumbs, navigateToUrl, params, setBreadcrumbs, setTitle]);
};
exports.useBreadcrumbs = useBreadcrumbs;