"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingEmbeddable = ProfilingEmbeddable;
var _react = require("@emotion/react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ProfilingEmbeddable({
  embeddableFactoryId,
  height,
  ...props
}) {
  const {
    embeddable: embeddablePlugin
  } = (0, _public.useKibana)().services;
  const [embeddable, setEmbeddable] = (0, _react2.useState)();
  const embeddableRoot = (0, _react2.useRef)(null);
  (0, _react2.useEffect)(() => {
    async function createEmbeddable() {
      const factory = embeddablePlugin === null || embeddablePlugin === void 0 ? void 0 : embeddablePlugin.getEmbeddableFactory(embeddableFactoryId);
      const input = {
        ...props,
        id: 'embeddable_profiling'
      };
      const embeddableObject = await (factory === null || factory === void 0 ? void 0 : factory.create(input));
      setEmbeddable(embeddableObject);
    }
    createEmbeddable();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react2.useEffect)(() => {
    if (embeddableRoot.current && embeddable) {
      embeddable.render(embeddableRoot.current);
    }
  }, [embeddable, embeddableRoot]);
  (0, _react2.useEffect)(() => {
    if (embeddable) {
      embeddable.updateInput(props);
      embeddable.reload();
    }
  }, [embeddable, props]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        width: 100%;
        height: ${height};
        display: flex;
        flex: 1 1 100%;
        z-index: 1;
        min-height: 0;
      `,
    ref: embeddableRoot
  });
}