"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBarPortal = SearchBarPortal;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _eui = require("@elastic/eui");
var _reactReversePortal = require("react-reverse-portal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SearchBarPortal({
  children
}) {
  const portalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      var _mainContent$childNod;
      const mainContent = globalThis.document.querySelector('main');
      if (!mainContent) return;
      const element = document.createElement('div');
      element.setAttribute('id', 'searchBarContainer');
      _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: portalNode
      }), element);
      if ((_mainContent$childNod = mainContent.childNodes) !== null && _mainContent$childNod !== void 0 && _mainContent$childNod[0]) {
        var _mainContent$childNod2;
        mainContent.insertBefore(element, (_mainContent$childNod2 = mainContent.childNodes) === null || _mainContent$childNod2 === void 0 ? void 0 : _mainContent$childNod2[0]);
      }
    }, 10);
    return () => {
      portalNode.unmount();
    };
  }, [portalNode]);
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: portalNode
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    borderRadius: "none",
    hasBorder: true,
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), children));
}