"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRANSACTION_TIME_TO_FIRST_BYTE = exports.TRANSACTION_SAMPLED = exports.TRANSACTION_ROOT = exports.TRANSACTION_RESULT = exports.TRANSACTION_PAGE_URL = exports.TRANSACTION_NAME = exports.TRANSACTION_ID = exports.TRANSACTION_DURATION_HISTOGRAM = exports.TRANSACTION_DURATION = exports.TRANSACTION_DOM_INTERACTIVE = exports.TRACE_ID = exports.TBT_FIELD = exports.SPAN_TYPE = exports.SPAN_SUBTYPE = exports.SPAN_SELF_TIME_SUM = exports.SPAN_NAME = exports.SPAN_ID = exports.SPAN_DURATION = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT = exports.SPAN_DESTINATION_SERVICE_RESOURCE = exports.SPAN_ACTION = exports.SERVICE_VERSION = exports.SERVICE_RUNTIME_VERSION = exports.SERVICE_RUNTIME_NAME = exports.SERVICE_NODE_NAME = exports.SERVICE_NAME = exports.SERVICE_LANGUAGE_VERSION = exports.SERVICE_LANGUAGE_NAME = exports.SERVICE_FRAMEWORK_VERSION = exports.SERVICE_FRAMEWORK_NAME = exports.SERVICE_ENVIRONMENT = exports.SERVICE = exports.PROFILE_WALL_US = exports.PROFILE_TOP_ID = exports.PROFILE_STACK = exports.PROFILE_SAMPLES_COUNT = exports.PROFILE_INUSE_SPACE = exports.PROFILE_INUSE_OBJECTS = exports.PROFILE_ID = exports.PROFILE_DURATION = exports.PROFILE_CPU_NS = exports.PROFILE_ALLOC_SPACE = exports.PROFILE_ALLOC_OBJECTS = exports.PROCESSOR_EVENT = exports.POD_NAME = exports.PARENT_ID = exports.OBSERVER_VERSION_MAJOR = exports.OBSERVER_LISTENING = exports.OBSERVER_HOSTNAME = exports.METRIC_SYSTEM_TOTAL_MEMORY = exports.METRIC_SYSTEM_MEMORY_USAGE = exports.METRIC_SYSTEM_FREE_MEMORY = exports.METRIC_SYSTEM_CPU_USAGE = exports.METRIC_SYSTEM_CPU_PERCENT = exports.METRIC_PROCESS_CPU_PERCENT = exports.METRIC_JAVA_THREAD_COUNT = exports.METRIC_JAVA_NON_HEAP_MEMORY_USED = exports.METRIC_JAVA_NON_HEAP_MEMORY_MAX = exports.METRIC_JAVA_NON_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_HEAP_MEMORY_USED = exports.METRIC_JAVA_HEAP_MEMORY_MAX = exports.METRIC_JAVA_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_GC_TIME = exports.METRIC_JAVA_GC_COUNT = exports.METRIC_CGROUP_MEMORY_USAGE_BYTES = exports.METRIC_CGROUP_MEMORY_LIMIT_BYTES = exports.LCP_FIELD = exports.LABEL_NAME = exports.KUBERNETES = exports.HTTP_RESPONSE_STATUS_CODE = exports.HTTP_REQUEST_METHOD = exports.HOST_OS_PLATFORM = exports.HOST_HOSTNAME = exports.HOST = exports.FID_FIELD = exports.FCP_FIELD = exports.EVENT_OUTCOME = exports.ERROR_PAGE_URL = exports.ERROR_LOG_MESSAGE = exports.ERROR_LOG_LEVEL = exports.ERROR_GROUP_ID = exports.ERROR_EXC_TYPE = exports.ERROR_EXC_MESSAGE = exports.ERROR_EXC_HANDLED = exports.ERROR_CULPRIT = exports.DESTINATION_ADDRESS = exports.CONTAINER_ID = exports.CLS_FIELD = exports.CLOUD_REGION = exports.CLOUD_PROVIDER = exports.CLOUD_MACHINE_TYPE = exports.CLOUD_AVAILABILITY_ZONE = exports.CLOUD = exports.CLIENT_GEO_COUNTRY_NAME = exports.CLIENT_GEO_COUNTRY_ISO_CODE = exports.CLIENT_GEO = exports.AGENT_VERSION = exports.AGENT_NAME = exports.AGENT = void 0;
exports.USER_ID = exports.USER_AGENT_VERSION = exports.USER_AGENT_OS_VERSION = exports.USER_AGENT_OS = exports.USER_AGENT_ORIGINAL = exports.USER_AGENT_NAME = exports.USER_AGENT_DEVICE = exports.URL_FULL = exports.TRANSACTION_URL = exports.TRANSACTION_TYPE = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CLOUD = exports.CLOUD = 'cloud';
const CLOUD_AVAILABILITY_ZONE = exports.CLOUD_AVAILABILITY_ZONE = 'cloud.availability_zone';
const CLOUD_PROVIDER = exports.CLOUD_PROVIDER = 'cloud.provider';
const CLOUD_REGION = exports.CLOUD_REGION = 'cloud.region';
const CLOUD_MACHINE_TYPE = exports.CLOUD_MACHINE_TYPE = 'cloud.machine.type';
const SERVICE = exports.SERVICE = 'service';
const SERVICE_NAME = exports.SERVICE_NAME = 'service.name';
const SERVICE_ENVIRONMENT = exports.SERVICE_ENVIRONMENT = 'service.environment';
const SERVICE_FRAMEWORK_NAME = exports.SERVICE_FRAMEWORK_NAME = 'service.framework.name';
const SERVICE_FRAMEWORK_VERSION = exports.SERVICE_FRAMEWORK_VERSION = 'service.framework.version';
const SERVICE_LANGUAGE_NAME = exports.SERVICE_LANGUAGE_NAME = 'service.language.name';
const SERVICE_LANGUAGE_VERSION = exports.SERVICE_LANGUAGE_VERSION = 'service.language.version';
const SERVICE_RUNTIME_NAME = exports.SERVICE_RUNTIME_NAME = 'service.runtime.name';
const SERVICE_RUNTIME_VERSION = exports.SERVICE_RUNTIME_VERSION = 'service.runtime.version';
const SERVICE_NODE_NAME = exports.SERVICE_NODE_NAME = 'service.node.name';
const SERVICE_VERSION = exports.SERVICE_VERSION = 'service.version';
const AGENT = exports.AGENT = 'agent';
const AGENT_NAME = exports.AGENT_NAME = 'agent.name';
const AGENT_VERSION = exports.AGENT_VERSION = 'agent.version';
const URL_FULL = exports.URL_FULL = 'url.full';
const HTTP_REQUEST_METHOD = exports.HTTP_REQUEST_METHOD = 'http.request.method';
const HTTP_RESPONSE_STATUS_CODE = exports.HTTP_RESPONSE_STATUS_CODE = 'http.response.status_code';
const USER_ID = exports.USER_ID = 'user.id';
const USER_AGENT_ORIGINAL = exports.USER_AGENT_ORIGINAL = 'user_agent.original';
const USER_AGENT_NAME = exports.USER_AGENT_NAME = 'user_agent.name';
const USER_AGENT_VERSION = exports.USER_AGENT_VERSION = 'user_agent.version';
const DESTINATION_ADDRESS = exports.DESTINATION_ADDRESS = 'destination.address';
const OBSERVER_HOSTNAME = exports.OBSERVER_HOSTNAME = 'observer.hostname';
const OBSERVER_VERSION_MAJOR = exports.OBSERVER_VERSION_MAJOR = 'observer.version_major';
const OBSERVER_LISTENING = exports.OBSERVER_LISTENING = 'observer.listening';
const PROCESSOR_EVENT = exports.PROCESSOR_EVENT = 'processor.event';
const TRANSACTION_DURATION = exports.TRANSACTION_DURATION = 'transaction.duration.us';
const TRANSACTION_DURATION_HISTOGRAM = exports.TRANSACTION_DURATION_HISTOGRAM = 'transaction.duration.histogram';
const TRANSACTION_TYPE = exports.TRANSACTION_TYPE = 'transaction.type';
const TRANSACTION_RESULT = exports.TRANSACTION_RESULT = 'transaction.result';
const TRANSACTION_NAME = exports.TRANSACTION_NAME = 'transaction.name';
const TRANSACTION_ID = exports.TRANSACTION_ID = 'transaction.id';
const TRANSACTION_SAMPLED = exports.TRANSACTION_SAMPLED = 'transaction.sampled';
const TRANSACTION_PAGE_URL = exports.TRANSACTION_PAGE_URL = 'transaction.page.url';
// for transaction metrics
const TRANSACTION_ROOT = exports.TRANSACTION_ROOT = 'transaction.root';
const EVENT_OUTCOME = exports.EVENT_OUTCOME = 'event.outcome';
const TRACE_ID = exports.TRACE_ID = 'trace.id';
const SPAN_DURATION = exports.SPAN_DURATION = 'span.duration.us';
const SPAN_TYPE = exports.SPAN_TYPE = 'span.type';
const SPAN_SUBTYPE = exports.SPAN_SUBTYPE = 'span.subtype';
const SPAN_SELF_TIME_SUM = exports.SPAN_SELF_TIME_SUM = 'span.self_time.sum.us';
const SPAN_ACTION = exports.SPAN_ACTION = 'span.action';
const SPAN_NAME = exports.SPAN_NAME = 'span.name';
const SPAN_ID = exports.SPAN_ID = 'span.id';
const SPAN_DESTINATION_SERVICE_RESOURCE = exports.SPAN_DESTINATION_SERVICE_RESOURCE = 'span.destination.service.resource';
const SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_COUNT = 'span.destination.service.response_time.count';
const SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM = exports.SPAN_DESTINATION_SERVICE_RESPONSE_TIME_SUM = 'span.destination.service.response_time.sum.us';

// Parent ID for a transaction or span
const PARENT_ID = exports.PARENT_ID = 'parent.id';
const ERROR_GROUP_ID = exports.ERROR_GROUP_ID = 'error.grouping_key';
const ERROR_CULPRIT = exports.ERROR_CULPRIT = 'error.culprit';
const ERROR_LOG_LEVEL = exports.ERROR_LOG_LEVEL = 'error.log.level';
const ERROR_LOG_MESSAGE = exports.ERROR_LOG_MESSAGE = 'error.log.message';
const ERROR_EXC_MESSAGE = exports.ERROR_EXC_MESSAGE = 'error.exception.message'; // only to be used in es queries, since error.exception is now an array
const ERROR_EXC_HANDLED = exports.ERROR_EXC_HANDLED = 'error.exception.handled'; // only to be used in es queries, since error.exception is now an array
const ERROR_EXC_TYPE = exports.ERROR_EXC_TYPE = 'error.exception.type';
const ERROR_PAGE_URL = exports.ERROR_PAGE_URL = 'error.page.url';

// METRICS
const METRIC_SYSTEM_FREE_MEMORY = exports.METRIC_SYSTEM_FREE_MEMORY = 'system.memory.actual.free';
const METRIC_SYSTEM_MEMORY_USAGE = exports.METRIC_SYSTEM_MEMORY_USAGE = 'system.memory.usage';
const METRIC_SYSTEM_CPU_USAGE = exports.METRIC_SYSTEM_CPU_USAGE = 'system.cpu.usage';
const METRIC_SYSTEM_TOTAL_MEMORY = exports.METRIC_SYSTEM_TOTAL_MEMORY = 'system.memory.total';
const METRIC_SYSTEM_CPU_PERCENT = exports.METRIC_SYSTEM_CPU_PERCENT = 'system.cpu.total.norm.pct';
const METRIC_PROCESS_CPU_PERCENT = exports.METRIC_PROCESS_CPU_PERCENT = 'system.process.cpu.total.norm.pct';
const METRIC_CGROUP_MEMORY_LIMIT_BYTES = exports.METRIC_CGROUP_MEMORY_LIMIT_BYTES = 'system.process.cgroup.memory.mem.limit.bytes';
const METRIC_CGROUP_MEMORY_USAGE_BYTES = exports.METRIC_CGROUP_MEMORY_USAGE_BYTES = 'system.process.cgroup.memory.mem.usage.bytes';
const METRIC_JAVA_HEAP_MEMORY_MAX = exports.METRIC_JAVA_HEAP_MEMORY_MAX = 'jvm.memory.heap.max';
const METRIC_JAVA_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_HEAP_MEMORY_COMMITTED = 'jvm.memory.heap.committed';
const METRIC_JAVA_HEAP_MEMORY_USED = exports.METRIC_JAVA_HEAP_MEMORY_USED = 'jvm.memory.heap.used';
const METRIC_JAVA_NON_HEAP_MEMORY_MAX = exports.METRIC_JAVA_NON_HEAP_MEMORY_MAX = 'jvm.memory.non_heap.max';
const METRIC_JAVA_NON_HEAP_MEMORY_COMMITTED = exports.METRIC_JAVA_NON_HEAP_MEMORY_COMMITTED = 'jvm.memory.non_heap.committed';
const METRIC_JAVA_NON_HEAP_MEMORY_USED = exports.METRIC_JAVA_NON_HEAP_MEMORY_USED = 'jvm.memory.non_heap.used';
const METRIC_JAVA_THREAD_COUNT = exports.METRIC_JAVA_THREAD_COUNT = 'jvm.thread.count';
const METRIC_JAVA_GC_COUNT = exports.METRIC_JAVA_GC_COUNT = 'jvm.gc.count';
const METRIC_JAVA_GC_TIME = exports.METRIC_JAVA_GC_TIME = 'jvm.gc.time';
const LABEL_NAME = exports.LABEL_NAME = 'labels.name';
const HOST = exports.HOST = 'host';
const HOST_HOSTNAME = exports.HOST_HOSTNAME = 'host.hostname';
const HOST_OS_PLATFORM = exports.HOST_OS_PLATFORM = 'host.os.platform';
const CONTAINER_ID = exports.CONTAINER_ID = 'container.id';
const KUBERNETES = exports.KUBERNETES = 'kubernetes';
const POD_NAME = exports.POD_NAME = 'kubernetes.pod.name';
const CLIENT_GEO_COUNTRY_ISO_CODE = exports.CLIENT_GEO_COUNTRY_ISO_CODE = 'client.geo.country_iso_code';
const CLIENT_GEO_COUNTRY_NAME = exports.CLIENT_GEO_COUNTRY_NAME = 'client.geo.country_name';

// RUM Labels
const TRANSACTION_URL = exports.TRANSACTION_URL = 'url.full';
const CLIENT_GEO = exports.CLIENT_GEO = 'client.geo';
const USER_AGENT_DEVICE = exports.USER_AGENT_DEVICE = 'user_agent.device.name';
const USER_AGENT_OS = exports.USER_AGENT_OS = 'user_agent.os.name';
const USER_AGENT_OS_VERSION = exports.USER_AGENT_OS_VERSION = 'user_agent.os.version';
const TRANSACTION_TIME_TO_FIRST_BYTE = exports.TRANSACTION_TIME_TO_FIRST_BYTE = 'transaction.marks.agent.timeToFirstByte';
const TRANSACTION_DOM_INTERACTIVE = exports.TRANSACTION_DOM_INTERACTIVE = 'transaction.marks.agent.domInteractive';
const FCP_FIELD = exports.FCP_FIELD = 'transaction.marks.agent.firstContentfulPaint';
const LCP_FIELD = exports.LCP_FIELD = 'transaction.marks.agent.largestContentfulPaint';
const TBT_FIELD = exports.TBT_FIELD = 'transaction.experience.tbt';
const FID_FIELD = exports.FID_FIELD = 'transaction.experience.fid';
const CLS_FIELD = exports.CLS_FIELD = 'transaction.experience.cls';
const PROFILE_ID = exports.PROFILE_ID = 'profile.id';
const PROFILE_DURATION = exports.PROFILE_DURATION = 'profile.duration';
const PROFILE_TOP_ID = exports.PROFILE_TOP_ID = 'profile.top.id';
const PROFILE_STACK = exports.PROFILE_STACK = 'profile.stack';
const PROFILE_SAMPLES_COUNT = exports.PROFILE_SAMPLES_COUNT = 'profile.samples.count';
const PROFILE_CPU_NS = exports.PROFILE_CPU_NS = 'profile.cpu.ns';
const PROFILE_WALL_US = exports.PROFILE_WALL_US = 'profile.wall.us';
const PROFILE_ALLOC_OBJECTS = exports.PROFILE_ALLOC_OBJECTS = 'profile.alloc_objects.count';
const PROFILE_ALLOC_SPACE = exports.PROFILE_ALLOC_SPACE = 'profile.alloc_space.bytes';
const PROFILE_INUSE_OBJECTS = exports.PROFILE_INUSE_OBJECTS = 'profile.inuse_objects.count';
const PROFILE_INUSE_SPACE = exports.PROFILE_INUSE_SPACE = 'profile.inuse_space.bytes';