"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.evaluateRule = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _get_interval_in_seconds = require("../../../../../common/utils/get_interval_in_seconds");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _create_timerange = require("./create_timerange");
var _get_data = require("./get_data");
var _check_missing_group = require("./check_missing_group");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const evaluateRule = async (esClient, params, dataView, timeFieldName, compositeSize, alertOnGroupDisappear, logger, timeframe, lastPeriodEnd, missingGroups = []) => {
  const {
    criteria,
    groupBy,
    searchConfiguration
  } = params;
  return Promise.all(criteria.map(async criterion => {
    const interval = `${criterion.timeSize}${criterion.timeUnit}`;
    const intervalAsSeconds = (0, _get_interval_in_seconds.getIntervalInSeconds)(interval);
    const intervalAsMS = intervalAsSeconds * 1000;
    const isRateAggregation = criterion.metrics.some(metric => metric.aggType === _types.Aggregators.RATE);
    const calculatedTimerange = (0, _create_timerange.createTimerange)(intervalAsMS, timeframe, lastPeriodEnd, isRateAggregation);
    const currentValues = await (0, _get_data.getData)(esClient, criterion, dataView, timeFieldName, groupBy, searchConfiguration, compositeSize, alertOnGroupDisappear, calculatedTimerange, logger, lastPeriodEnd);
    const verifiedMissingGroups = await (0, _check_missing_group.checkMissingGroups)(esClient, criterion, dataView, timeFieldName, groupBy, searchConfiguration, logger, calculatedTimerange, missingGroups);
    for (const missingGroup of verifiedMissingGroups) {
      if (currentValues[missingGroup.key] == null) {
        currentValues[missingGroup.key] = {
          value: null,
          trigger: false,
          bucketKey: missingGroup.bucketKey
        };
      }
    }
    const evaluations = {};
    for (const key of Object.keys(currentValues)) {
      const result = currentValues[key];
      if (result.trigger || result.value === null) {
        evaluations[key] = {
          ...criterion,
          currentValue: result.value,
          timestamp: (0, _moment.default)(calculatedTimerange.end).toISOString(),
          shouldFire: result.trigger,
          isNoData: result.value === null,
          bucketKey: result.bucketKey,
          context: {
            cloud: result.cloud,
            host: result.host,
            container: result.container,
            orchestrator: result.orchestrator,
            labels: result.labels,
            tags: result.tags
          }
        };
      }
    }
    return evaluations;
  }));
};
exports.evaluateRule = evaluateRule;