"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityRuleTypes = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _get_view_in_app_url = require("../../common/custom_threshold_rule/get_view_in_app_url");
var _get_group = require("../../common/custom_threshold_rule/helpers/get_group");
var _validation = require("../components/custom_threshold/components/validation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const thresholdDefaultActionMessage = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alerting.threshold.defaultActionMessage', {
  defaultMessage: `\\{\\{context.reason\\}\\}

\\{\\{rule.name\\}\\} is active.

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const thresholdDefaultRecoveryMessage = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alerting.threshold.defaultRecoveryMessage', {
  defaultMessage: `\\{\\{rule.name\\}\\} has recovered.

[View alert details](\\{\\{context.alertDetailsUrl\\}\\})
`
});
const getDataViewId = searchConfiguration => {
  var _searchConfiguration$;
  return typeof (searchConfiguration === null || searchConfiguration === void 0 ? void 0 : searchConfiguration.index) === 'string' ? searchConfiguration.index : searchConfiguration === null || searchConfiguration === void 0 ? void 0 : (_searchConfiguration$ = searchConfiguration.index) === null || _searchConfiguration$ === void 0 ? void 0 : _searchConfiguration$.title;
};
const registerObservabilityRuleTypes = async (observabilityRuleTypeRegistry, uiSettings, logsExplorerLocator) => {
  const validateCustomThresholdWithUiSettings = ({
    criteria,
    searchConfiguration
  }) => (0, _validation.validateCustomThreshold)({
    criteria,
    searchConfiguration,
    uiSettings
  });
  observabilityRuleTypeRegistry.register({
    id: _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID,
    description: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertDescription', {
      defaultMessage: 'Alert when any Observability data type reaches or exceeds a given value.'
    }),
    iconClass: 'bell',
    documentationUrl(docLinks) {
      return `${docLinks.links.observability.customThreshold}`;
    },
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/custom_threshold/custom_threshold_rule_expression')))),
    validate: validateCustomThresholdWithUiSettings,
    defaultActionMessage: thresholdDefaultActionMessage,
    defaultRecoveryMessage: thresholdDefaultRecoveryMessage,
    requiresAppContext: false,
    format: ({
      fields
    }) => {
      var _fields$ALERT_RULE_PA, _fields$ALERT_RULE_PA2, _fields$ALERT_REASON;
      const groups = (0, _get_group.getGroups)(fields[_ruleDataUtils.ALERT_GROUP_FIELD], fields[_ruleDataUtils.ALERT_GROUP_VALUE]);
      const searchConfiguration = (_fields$ALERT_RULE_PA = fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _fields$ALERT_RULE_PA === void 0 ? void 0 : _fields$ALERT_RULE_PA.searchConfiguration;
      const criteria = (_fields$ALERT_RULE_PA2 = fields[_ruleDataUtils.ALERT_RULE_PARAMETERS]) === null || _fields$ALERT_RULE_PA2 === void 0 ? void 0 : _fields$ALERT_RULE_PA2.criteria;
      const metrics = criteria.length === 1 ? criteria[0].metrics : [];
      const dataViewId = getDataViewId(searchConfiguration);
      return {
        reason: (_fields$ALERT_REASON = fields[_ruleDataUtils.ALERT_REASON]) !== null && _fields$ALERT_REASON !== void 0 ? _fields$ALERT_REASON : '-',
        link: (0, _get_view_in_app_url.getViewInAppUrl)({
          dataViewId,
          groups,
          logsExplorerLocator,
          metrics,
          searchConfiguration,
          startedAt: fields[_ruleDataUtils.ALERT_START]
        }),
        hasBasePath: true
      };
    },
    alertDetailsAppSection: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/custom_threshold/components/alert_details_app_section/alert_details_app_section')))),
    priority: 110
  });
};
exports.registerObservabilityRuleTypes = registerObservabilityRuleTypes;