"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesPage = RulesPage;
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _common = require("@kbn/alerting-plugin/common");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _constants = require("../../../common/constants");
var _paths = require("../../../common/locators/paths");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _kibana_react = require("../../utils/kibana_react");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _rules_tab = require("./rules_tab");
var _use_get_available_rules_with_descriptions = require("../../hooks/use_get_available_rules_with_descriptions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GlobalLogsTab = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./global_logs_tab'))));
const RULES_TAB_NAME = 'rules';
function RulesPage({
  activeTab = RULES_TAB_NAME
}) {
  const {
    http,
    docLinks,
    notifications: {
      toasts
    },
    observabilityAIAssistant,
    triggersActionsUi: {
      ruleTypeRegistry,
      getAddRuleFlyout: AddRuleFlyout,
      getRulesSettingsLink: RulesSettingsLink
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const [ruleTypeModalVisibility, setRuleTypeModalVisibility] = (0, _react.useState)(false);
  const [ruleTypeIdToCreate, setRuleTypeIdToCreate] = (0, _react.useState)(undefined);
  const [addRuleFlyoutVisibility, setAddRuleFlyoutVisibility] = (0, _react.useState)(false);
  const [stateRefresh, setRefresh] = (0, _react.useState)(new Date());
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: http.basePath.prepend('/app/observability/alerts'),
    deepLinkId: 'observability-overview:alerts'
  }, {
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }]);
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    ruleTypesState: {
      data: ruleTypes
    }
  } = (0, _public2.useLoadRuleTypesQuery)({
    filteredRuleTypes
  });
  const authorizedRuleTypes = [...ruleTypes.values()];
  const authorizedToCreateAnyRules = authorizedRuleTypes.some(ruleType => {
    var _ruleType$authorizedC;
    return (_ruleType$authorizedC = ruleType.authorizedConsumers[_common.ALERTING_FEATURE_ID]) === null || _ruleType$authorizedC === void 0 ? void 0 : _ruleType$authorizedC.all;
  });
  const {
    setScreenContext
  } = (observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service) || {};
  const ruleTypesWithDescriptions = (0, _use_get_available_rules_with_descriptions.useGetAvailableRulesWithDescriptions)();
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      screenDescription: `The rule types that are available are: ${JSON.stringify(ruleTypesWithDescriptions)}`,
      starterPrompts: [{
        title: _i18n.i18n.translate('xpack.observability.aiAssistant.starterPrompts.explainRules.title', {
          defaultMessage: 'Explain'
        }),
        prompt: _i18n.i18n.translate('xpack.observability.aiAssistant.starterPrompts.explainRules.prompt', {
          defaultMessage: `Can you explain the rule types that are available?`
        }),
        icon: 'sparkles'
      }]
    });
  }, [filteredRuleTypes, ruleTypesWithDescriptions, setScreenContext]);
  const tabs = [{
    name: 'rules',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.rulePage.rulesTabTitle",
      defaultMessage: "Rules"
    }),
    onClick: () => history.push(_paths.RULES_PATH),
    isSelected: activeTab === RULES_TAB_NAME
  }, {
    name: 'logs',
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.rulePage.logsTabTitle",
      defaultMessage: "Logs"
    }),
    onClick: () => history.push(_paths.RULES_LOGS_PATH),
    ['data-test-subj']: 'ruleLogsTab',
    isSelected: activeTab !== RULES_TAB_NAME
  }];
  const rightSideItems = [...(activeTab === RULES_TAB_NAME ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "createRuleButton",
    disabled: !authorizedToCreateAnyRules,
    fill: true,
    iconType: "plusInCircle",
    key: "create-alert",
    onClick: () => setRuleTypeModalVisibility(true)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.rules.addRuleButtonLabel",
    defaultMessage: "Create rule"
  }))] : []), /*#__PURE__*/_react.default.createElement(RulesSettingsLink, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "documentationLink",
    href: docLinks.links.observability.createAlerts,
    iconType: "help",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.rules.docsLinkText",
    defaultMessage: "Documentation"
  }))];
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.observability.rulesTitle', {
        defaultMessage: 'Rules'
      }),
      rightSideItems,
      tabs
    },
    "data-test-subj": "rulesPage"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, activeTab === RULES_TAB_NAME ? /*#__PURE__*/_react.default.createElement(_rules_tab.RulesTab, {
    setRefresh: setRefresh,
    stateRefresh: stateRefresh
  }) : /*#__PURE__*/_react.default.createElement(GlobalLogsTab, null))), ruleTypeModalVisibility && /*#__PURE__*/_react.default.createElement(_alertsUiShared.RuleTypeModal, {
    onClose: () => setRuleTypeModalVisibility(false),
    onSelectRuleType: ruleTypeId => {
      setRuleTypeIdToCreate(ruleTypeId);
      setRuleTypeModalVisibility(false);
      setAddRuleFlyoutVisibility(true);
    },
    http: http,
    toasts: toasts,
    registeredRuleTypes: ruleTypeRegistry.list(),
    filteredRuleTypes: filteredRuleTypes
  }), addRuleFlyoutVisibility && /*#__PURE__*/_react.default.createElement(AddRuleFlyout, {
    ruleTypeId: ruleTypeIdToCreate,
    canChangeTrigger: false,
    consumer: _common.ALERTING_FEATURE_ID,
    filteredRuleTypes: filteredRuleTypes,
    validConsumers: _constants.observabilityRuleCreationValidConsumers,
    initialSelectedConsumer: _ruleDataUtils.AlertConsumers.LOGS,
    onClose: () => {
      setAddRuleFlyoutVisibility(false);
    },
    onSave: () => {
      setRefresh(new Date());
      return Promise.resolve();
    },
    hideGrouping: true,
    useRuleProducer: true
  }));
}