"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsPage = RuleDetailsPage;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _public = require("@kbn/observability-shared-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_fetch_rule = require("../../hooks/use_fetch_rule");
var _use_fetch_rule_types = require("../../hooks/use_fetch_rule_types");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _page_title = require("./components/page_title");
var _delete_confirmation_modal = require("./components/delete_confirmation_modal");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _no_rule_found_panel = require("./components/no_rule_found_panel");
var _header_actions = require("./components/header_actions");
var _rule_details_tabs = require("./components/rule_details_tabs");
var _get_health_color = require("./helpers/get_health_color");
var _is_rule_editable = require("./helpers/is_rule_editable");
var _common2 = require("../../../common");
var _constants = require("../../../common/constants");
var _constants2 = require("./constants");
var _paths = require("../../../common/locators/paths");
var _alert_summary_widget = require("../../utils/alert_summary_widget");
var _header_menu = require("../overview/components/header_menu/header_menu");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuleDetailsPage() {
  var _rule$executionStatus;
  const {
    application: {
      capabilities,
      navigateToUrl
    },
    http: {
      basePath
    },
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      actionTypeRegistry,
      ruleTypeRegistry,
      getAlertSummaryWidget: AlertSummaryWidget,
      getEditRuleFlyout: EditRuleFlyout,
      getRuleDefinition: RuleDefinition,
      getRuleStatusPanel: RuleStatusPanel
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    rule,
    isLoading,
    isError,
    refetch
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId
  });
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    ruleTypes
  } = (0, _use_fetch_rule_types.useFetchRuleTypes)({
    filterByRuleTypeIds: filteredRuleTypes
  });
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: basePath.prepend(_paths.paths.observability.alerts),
    deepLinkId: 'observability-overview:alerts'
  }, {
    href: basePath.prepend(_paths.paths.observability.rules),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }, {
    text: rule && rule.name
  }]);
  const [activeTabId, setActiveTabId] = (0, _react.useState)(() => {
    const searchParams = new URLSearchParams(search);
    const urlTabId = searchParams.get(_constants2.RULE_DETAILS_TAB_URL_STORAGE_KEY);
    return urlTabId && [_constants2.RULE_DETAILS_EXECUTION_TAB, _constants2.RULE_DETAILS_ALERTS_TAB].includes(urlTabId) ? urlTabId : _constants2.RULE_DETAILS_ALERTS_TAB;
  });
  const [esQuery, setEsQuery] = (0, _react.useState)();
  const [alertSummaryWidgetTimeRange, setAlertSummaryWidgetTimeRange] = (0, _react.useState)(_alert_summary_widget.getDefaultAlertSummaryTimeRange);
  const [isEditRuleFlyoutVisible, setEditRuleFlyoutVisible] = (0, _react.useState)(false);
  const [ruleToDelete, setRuleToDelete] = (0, _react.useState)(undefined);
  const [isRuleDeleting, setIsRuleDeleting] = (0, _react.useState)(false);
  const tabsRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    setAlertSummaryWidgetTimeRange((0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)());
  }, [esQuery]);
  const handleSetTabId = async tabId => {
    var _locators$get;
    setActiveTabId(tabId);
    await ((_locators$get = locators.get(_common2.ruleDetailsLocatorID)) === null || _locators$get === void 0 ? void 0 : _locators$get.navigate({
      ruleId,
      tabId
    }, {
      replace: true
    }));
  };
  const handleAlertSummaryWidgetClick = async (status = _constants.ALERT_STATUS_ALL) => {
    var _locators$get2, _tabsRef$current;
    setAlertSummaryWidgetTimeRange((0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)());
    await ((_locators$get2 = locators.get(_common2.ruleDetailsLocatorID)) === null || _locators$get2 === void 0 ? void 0 : _locators$get2.navigate({
      rangeFrom: _alert_summary_widget.defaultTimeRange.from,
      rangeTo: _alert_summary_widget.defaultTimeRange.to,
      ruleId,
      status,
      tabId: _constants2.RULE_DETAILS_ALERTS_TAB
    }, {
      replace: true
    }));
    setActiveTabId(_constants2.RULE_DETAILS_ALERTS_TAB);
    (_tabsRef$current = tabsRef.current) === null || _tabsRef$current === void 0 ? void 0 : _tabsRef$current.scrollIntoView({
      behavior: 'smooth'
    });
  };
  const handleEditRule = () => {
    setEditRuleFlyoutVisible(true);
  };
  const handleCloseRuleFlyout = () => {
    setEditRuleFlyoutVisible(false);
  };
  const handleDeleteRule = () => {
    setRuleToDelete(rule === null || rule === void 0 ? void 0 : rule.id);
    setEditRuleFlyoutVisible(false);
  };
  const handleIsDeletingRule = () => {
    setIsRuleDeleting(true);
  };
  const handleIsRuleDeleted = () => {
    setRuleToDelete(undefined);
    setIsRuleDeleting(false);
    navigateToUrl(basePath.prepend(_paths.paths.observability.rules));
  };
  const ruleType = ruleTypes === null || ruleTypes === void 0 ? void 0 : ruleTypes.find(type => type.id === (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId));
  const isEditable = (0, _is_rule_editable.isRuleEditable)({
    capabilities,
    rule,
    ruleType,
    ruleTypeRegistry
  });
  const featureIds = (rule === null || rule === void 0 ? void 0 : rule.consumer) === _common.ALERTING_FEATURE_ID && ruleType !== null && ruleType !== void 0 && ruleType.producer ? [ruleType.producer] : rule ? [rule.consumer] : [];
  const ruleStatusMessage = (rule === null || rule === void 0 ? void 0 : (_rule$executionStatus = rule.executionStatus.error) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.reason) === _common.RuleExecutionStatusErrorReasons.License ? rulesStatusesTranslationsMapping.noLicense : rule ? rulesStatusesTranslationsMapping[rule.executionStatus.status] : '';
  if (isLoading || isRuleDeleting) return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  if (!rule || isError) return /*#__PURE__*/_react.default.createElement(_no_rule_found_panel.NoRuleFoundPanel, null);
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "ruleDetails",
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
        rule: rule
      }),
      bottomBorder: false,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        isLoading: isLoading || isRuleDeleting,
        isRuleEditable: isEditable,
        onEditRule: handleEditRule,
        onDeleteRule: handleDeleteRule
      })]
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 350
    }
  }, /*#__PURE__*/_react.default.createElement(RuleStatusPanel, {
    rule: rule,
    isEditable: isEditable,
    requestRefresh: refetch,
    healthColor: (0, _get_health_color.getHealthColor)(rule.executionStatus.status),
    statusMessage: ruleStatusMessage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 350
    }
  }, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    featureIds: featureIds,
    onClick: handleAlertSummaryWidgetClick,
    timeRange: alertSummaryWidgetTimeRange,
    filter: {
      term: {
        'kibana.alert.rule.uuid': ruleId
      }
    }
  })), /*#__PURE__*/_react.default.createElement(RuleDefinition, {
    actionTypeRegistry: actionTypeRegistry,
    rule: rule,
    ruleTypeRegistry: ruleTypeRegistry,
    onEditRule: async () => {
      refetch();
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: tabsRef
  }), /*#__PURE__*/_react.default.createElement(_rule_details_tabs.RuleDetailsTabs, {
    esQuery: esQuery,
    featureIds: featureIds,
    rule: rule,
    ruleId: ruleId,
    ruleType: ruleType,
    activeTabId: activeTabId,
    onEsQueryChange: setEsQuery,
    onSetTabId: handleSetTabId
  }), isEditRuleFlyoutVisible && /*#__PURE__*/_react.default.createElement(EditRuleFlyout, {
    initialRule: rule,
    onClose: handleCloseRuleFlyout,
    onSave: async () => {
      refetch();
    }
  }), ruleToDelete ? /*#__PURE__*/_react.default.createElement(_delete_confirmation_modal.DeleteConfirmationModal, {
    ruleIdToDelete: ruleToDelete,
    title: rule.name,
    onCancel: () => setRuleToDelete(undefined),
    onDeleting: handleIsDeletingRule,
    onDeleted: handleIsRuleDeleted
  }) : null);
}
const rulesStatusesTranslationsMapping = {
  ok: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusOk', {
    defaultMessage: 'Ok'
  }),
  active: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusActive', {
    defaultMessage: 'Active'
  }),
  error: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusError', {
    defaultMessage: 'Error'
  }),
  pending: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusPending', {
    defaultMessage: 'Pending'
  }),
  unknown: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusUnknown', {
    defaultMessage: 'Unknown'
  }),
  warning: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusWarning', {
    defaultMessage: 'Warning'
  }),
  noLicense: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusLicenseError', {
    defaultMessage: 'License Error'
  })
};