"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsTabs = RuleDetailsTabs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../utils/kibana_react");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
var _alert_search_bar_with_url_sync = require("../../../components/alert_search_bar/alert_search_bar_with_url_sync");
var _constants = require("../../../constants");
var _constants2 = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuleDetailsTabs({
  activeTabId,
  esQuery,
  featureIds,
  rule,
  ruleId,
  ruleType,
  onSetTabId,
  onEsQueryChange
}) {
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable,
      getRuleEventLogList: RuleEventLogList
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  const ruleQuery = (0, _react.useRef)([{
    query: `kibana.alert.rule.uuid: ${ruleId}`,
    language: 'kuery'
  }]);
  const tabs = [{
    id: _constants2.RULE_DETAILS_ALERTS_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.alertsTabText', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'ruleAlertListTab',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_alert_search_bar_with_url_sync.ObservabilityAlertSearchbarWithUrlSync, {
      appName: _constants2.RULE_DETAILS_ALERTS_SEARCH_BAR_ID,
      onEsQueryChange: onEsQueryChange,
      urlStorageKey: _constants2.RULE_DETAILS_SEARCH_BAR_URL_STORAGE_KEY,
      defaultSearchQueries: ruleQuery.current
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        minHeight: 450
      },
      direction: 'column'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, esQuery && featureIds && /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
      alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
      configurationId: _constants.RULE_DETAILS_ALERTS_TABLE_CONFIG_ID,
      id: _constants2.RULE_DETAILS_PAGE_ID,
      featureIds: featureIds,
      query: esQuery,
      showAlertStatusWithFlapping: true,
      cellContext: {
        observabilityRuleTypeRegistry
      }
    }))))
  }, {
    id: _constants2.RULE_DETAILS_EXECUTION_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.eventLogTabText', {
      defaultMessage: 'Execution history'
    }),
    'data-test-subj': 'eventLogListTab',
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        minHeight: 600
      },
      direction: 'column'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, rule && ruleType ? /*#__PURE__*/_react.default.createElement(RuleEventLogList, {
      ruleId: rule.id,
      ruleType: ruleType
    }) : null))
  }];
  const handleTabIdChange = newTabId => {
    onSetTabId(newTabId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "ruleDetailsTabbedContent",
    tabs: tabs,
    selectedTab: tabs.find(tab => tab.id === activeTabId),
    onTabClick: tab => {
      handleTabIdChange(tab.id);
    }
  });
}