"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingCallout = ObservabilityOnboardingCallout;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _use_observability_onboarding = require("../../../hooks/use_observability_onboarding");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ObservabilityOnboardingCallout() {
  const {
    application
  } = (0, _public.useKibana)().services;
  const trackMetric = (0, _public2.useUiTracker)({
    app: 'observability-overview'
  });
  const {
    isObservabilityOnboardingDismissed,
    dismissObservabilityOnboarding
  } = (0, _use_observability_onboarding.useObservabilityOnboarding)();
  const dismissOnboarding = (0, _react.useCallback)(() => {
    dismissObservabilityOnboarding();
    trackMetric({
      metric: 'observability_onboarding_dismiss'
    });
  }, [dismissObservabilityOnboarding, trackMetric]);
  const getStarted = () => {
    trackMetric({
      metric: 'observability_onboarding_get_started'
    });
    application === null || application === void 0 ? void 0 : application.navigateToApp('observabilityOnboarding');
  };
  return !isObservabilityOnboardingDismissed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "primary",
    "data-test-subj": "observability-onboarding-callout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding",
    defaultMessage: "Collect and analyze logs in observability"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding.description",
    defaultMessage: "Onboard your data in up to 5 minutes to start analysing it straight away."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    direction: "row",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "o11yObservabilityOnboardingDismissButton",
    size: "s",
    onClick: dismissOnboarding
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding.dismiss",
    defaultMessage: "Dismiss"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "o11yObservabilityOnboardingGetStartedButton",
    size: "s",
    onClick: getStarted
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.observabilityOnboarding.getStarted",
    defaultMessage: "Get started"
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null;
}