"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = HeaderMenuPortal;
var _react = _interopRequireWildcard(require("react"));
var _reactReversePortal = require("react-reverse-portal");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _kibana_react = require("../../../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line import/no-default-export
function HeaderMenuPortal({
  children,
  setHeaderActionMenu,
  theme$
}) {
  const {
    i18n
  } = (0, _kibana_react.useKibana)().services;
  const portalNode = (0, _react.useMemo)(() => (0, _reactReversePortal.createHtmlPortalNode)(), []);
  (0, _react.useEffect)(() => {
    setHeaderActionMenu(element => {
      const mount = (0, _reactKibanaMount.toMountPoint)( /*#__PURE__*/_react.default.createElement(_reactReversePortal.OutPortal, {
        node: portalNode
      }), {
        ...{
          theme: {
            theme$
          },
          i18n
        }
      });
      return mount(element);
    });
    return () => {
      portalNode.unmount();
      setHeaderActionMenu(undefined);
    };
  }, [portalNode, setHeaderActionMenu, i18n, theme$]);
  return /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: portalNode
  }, children);
}
module.exports = exports.default;