"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertActions = AlertActions;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/cases-plugin/common");
var _reactRouterDom = require("react-router-dom");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _constants = require("../../rule_details/constants");
var _paths = require("../../../../common/locators/paths");
var _kibana_react = require("../../../utils/kibana_react");
var _parse_alert = require("../helpers/parse_alert");
var _ = require("../../..");
var _alert_details = require("../../alert_details/alert_details");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertActions({
  config,
  observabilityRuleTypeRegistry,
  ...customActionsProps
}) {
  const {
    alert,
    refresh,
    id
  } = customActionsProps;
  const isSLODetailsPage = (0, _reactRouterDom.useRouteMatch)(_paths.SLO_DETAIL_PATH);
  const isInApp = Boolean(id === _common2.SLO_ALERTS_TABLE_ID && isSLODetailsPage);
  const {
    cases: {
      helpers: {
        getRuleIdFromEvent,
        canUseCases
      },
      hooks: {
        useCasesAddToNewCaseFlyout,
        useCasesAddToExistingCaseModal
      }
    },
    http: {
      basePath: {
        prepend
      }
    },
    triggersActionsUi
  } = (0, _kibana_react.useKibana)().services;
  const data = (0, _react.useMemo)(() => Object.entries(alert !== null && alert !== void 0 ? alert : {}).reduce((acc, [field, value]) => [...acc, {
    field,
    value: value
  }], []), [alert]);
  const ecsData = (0, _react.useMemo)(() => ({
    _id: alert._id,
    _index: alert._index
  }), [alert._id, alert._index]);
  const userCasesPermissions = canUseCases([_.observabilityFeatureId]);
  const [viewInAppUrl, setViewInAppUrl] = (0, _react.useState)();
  const parseObservabilityAlert = (0, _react.useMemo)(() => (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry), [observabilityRuleTypeRegistry]);
  const observabilityAlert = parseObservabilityAlert(alert);
  (0, _react.useEffect)(() => {
    const alertLink = observabilityAlert.link;
    if (!observabilityAlert.hasBasePath && prepend) {
      setViewInAppUrl(prepend(alertLink !== null && alertLink !== void 0 ? alertLink : ''));
    } else {
      setViewInAppUrl(alertLink);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const handleViewInAppUrl = (0, _react.useCallback)(() => {
    const alertLink = observabilityAlert.link;
    if (!observabilityAlert.hasBasePath) {
      setViewInAppUrl(prepend(alertLink !== null && alertLink !== void 0 ? alertLink : ''));
    } else {
      setViewInAppUrl(alertLink);
    }
  }, [observabilityAlert.link, observabilityAlert.hasBasePath, prepend]);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const caseAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_id, _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: (_ecsData$_id = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id !== void 0 ? _ecsData$_id : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      type: _common.AttachmentType.alert,
      rule: getRuleIdFromEvent({
        ecs: ecsData,
        data: data !== null && data !== void 0 ? data : []
      })
    }] : [];
  }, [ecsData, getRuleIdFromEvent, data]);
  const onSuccess = (0, _react.useCallback)(() => {
    refresh();
  }, [refresh]);
  const createCaseFlyout = useCasesAddToNewCaseFlyout({
    onSuccess
  });
  const selectCaseModal = useCasesAddToExistingCaseModal({
    onSuccess
  });
  const closeActionsPopover = () => {
    setIsPopoverOpen(false);
  };
  const toggleActionsPopover = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const handleAddToNewCaseClick = () => {
    createCaseFlyout.open({
      attachments: caseAttachments
    });
    closeActionsPopover();
  };
  const handleAddToExistingCaseClick = () => {
    selectCaseModal.open({
      getAttachments: () => caseAttachments
    });
    closeActionsPopover();
  };
  const DefaultRowActions = (0, _react.useMemo)(() => triggersActionsUi.getAlertsTableDefaultAlertActions({
    key: 'defaultRowActions',
    onActionExecuted: closeActionsPopover,
    isAlertDetailsEnabled: true,
    resolveRulePagePath: (ruleId, currentPageId) => currentPageId !== _constants.RULE_DETAILS_PAGE_ID ? _paths.paths.observability.ruleDetails(ruleId) : null,
    resolveAlertPagePath: (alertId, currentPageId) => currentPageId !== _alert_details.ALERT_DETAILS_PAGE_ID ? _paths.paths.observability.alertDetails(alertId) : null,
    ...customActionsProps
  }), [customActionsProps, triggersActionsUi]);
  const actionsMenuItems = [...(userCasesPermissions.create && userCasesPermissions.read ? [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-existing-case-action",
    key: "addToExistingCase",
    onClick: handleAddToExistingCaseClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alerts.actions.addToCase', {
    defaultMessage: 'Add to existing case'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "add-to-new-case-action",
    key: "addToNewCase",
    onClick: handleAddToNewCaseClick,
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alerts.actions.addToNewCase', {
    defaultMessage: 'Add to new case'
  }))] : []), DefaultRowActions];
  const actionsToolTip = actionsMenuItems.length <= 0 ? _i18n.i18n.translate('xpack.observability.alertsTable.notEnoughPermissions', {
    defaultMessage: 'Additional privileges required'
  }) : _i18n.i18n.translate('xpack.observability.alertsTable.moreActionsTextLabel', {
    defaultMessage: 'More actions'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewInAppUrl && !isInApp ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yAlertActionsButton",
    "aria-label": _i18n.i18n.translate('xpack.observability.alertsTable.viewInAppTextLabel', {
      defaultMessage: 'View in app'
    }),
    color: "text",
    onMouseOver: handleViewInAppUrl,
    href: viewInAppUrl,
    iconType: "eye",
    size: "s"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: actionsToolTip
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": actionsToolTip,
      color: "text",
      "data-test-subj": "alertsTableRowActionMore",
      display: "empty",
      iconType: "boxesHorizontal",
      onClick: toggleActionsPopover,
      size: "s"
    })),
    closePopover: closeActionsPopover,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: actionsMenuItems,
    "data-test-subj": "alertsTableActionsMenu"
  }))));
}