"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageTitle = PageTitle;
exports.pageTitleContent = pageTitleContent;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react2 = require("@emotion/react");
var _formatters = require("../../../../common/utils/formatters");
var _experimental_badge = require("../../../components/experimental_badge");
var _alert_details = require("../alert_details");
var _is_alert_details_enabled = require("../../../utils/is_alert_details_enabled");
var _use_plugin_context = require("../../../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function pageTitleContent(ruleCategory) {
  return _i18n.i18n.translate('xpack.observability.pages.alertDetails.pageTitle.title', {
    defaultMessage: '{ruleCategory} {ruleCategory, select, Anomaly {detected} Inventory {threshold breached} other {breached}}',
    values: {
      ruleCategory
    }
  });
}
function PageTitle({
  alert,
  alertStatus,
  dataTestSubj
}) {
  var _alert$fields$TIMESTA;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    config
  } = (0, _use_plugin_context.usePluginContext)();
  if (!alert) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  const showExperimentalBadge = alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID] === _alert_details.METRIC_THRESHOLD_ALERT_TYPE_ID;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "s"
  }, pageTitleContent(alert.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]), (0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alert, config) && showExperimentalBadge && /*#__PURE__*/_react.default.createElement(_experimental_badge.ExperimentalBadge, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, alertStatus && /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertLifecycleStatusBadge, {
    alertStatus: alertStatus,
    flapping: alert.fields[_ruleDataUtils.ALERT_FLAPPING]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.triggered",
    defaultMessage: "Triggered"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s"
  }, (0, _moment.default)(Number(alert.start)).locale(_i18n.i18n.getLocale()).fromNow()))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.duration",
    defaultMessage: "Duration"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s"
  }, (0, _formatters.asDuration)(Number(alert.fields[_ruleDataUtils.ALERT_DURATION]))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.pages.alertDetails.pageTitle.lastStatusUpdate",
    defaultMessage: "Last status update"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    css: (0, _react2.css)`
                font-weight: ${euiTheme.font.weight.semiBold};
              `,
    size: "s"
  }, (0, _moment.default)((_alert$fields$TIMESTA = alert.fields[_ruleDataUtils.TIMESTAMP]) === null || _alert$fields$TIMESTA === void 0 ? void 0 : _alert$fields$TIMESTA.toString()).locale(_i18n.i18n.getLocale()).fromNow())))));
}