"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailContextualInsights = AlertDetailContextualInsights;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _dedent = _interopRequireDefault(require("dedent"));
var _kibana_react = require("../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertDetailContextualInsights({
  alert
}) {
  const {
    services: {
      observabilityAIAssistant,
      http
    }
  } = (0, _kibana_react.useKibana)();
  const ObservabilityAIAssistantContextualInsight = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.ObservabilityAIAssistantContextualInsight;
  const getAlertContextMessages = (0, _react.useCallback)(async () => {
    const fields = alert === null || alert === void 0 ? void 0 : alert.formatted.fields;
    if (!observabilityAIAssistant || !fields || !alert) {
      return [];
    }
    try {
      const {
        alertContext
      } = await http.get('/internal/observability/assistant/alert_details_contextual_insights', {
        query: {
          alert_started_at: new Date(alert.formatted.start).toISOString(),
          // service fields
          'service.name': fields['service.name'],
          'service.environment': fields['service.environment'],
          'transaction.type': fields['transaction.type'],
          'transaction.name': fields['transaction.name'],
          // infra fields
          'host.name': fields['host.name'],
          'container.id': fields['container.id'],
          'kubernetes.pod.name': fields['kubernetes.pod.name']
        }
      });
      const obsAlertContext = alertContext.map(({
        description,
        data
      }) => `${description}:\n${JSON.stringify(data, null, 2)}`).join('\n\n');
      return observabilityAIAssistant.getContextualInsightMessages({
        message: `I'm looking at an alert and trying to understand why it was triggered`,
        instructions: (0, _dedent.default)(`I'm an SRE. I am looking at an alert that was triggered. I want to understand why it was triggered, what it means, and what I should do next.

        The following contextual information is available to help you understand the alert:
        ${obsAlertContext}

        Be brief and to the point.
        Do not list the alert details as bullet points.
        Refer to the contextual information provided above when relevant.
        Pay special attention to regressions in downstream dependencies like big increases or decreases in throughput, latency or failure rate
        Suggest reasons why the alert happened and what may have contributed to it.
        `)
      });
    } catch (e) {
      console.error('An error occurred while fetching alert context', e);
      return observabilityAIAssistant.getContextualInsightMessages({
        message: `I'm looking at an alert and trying to understand why it was triggered`,
        instructions: (0, _dedent.default)(`I'm an SRE. I am looking at an alert that was triggered. I want to understand why it was triggered, what it means, and what I should do next.`)
      });
    }
  }, [alert, http, observabilityAIAssistant]);
  if (!ObservabilityAIAssistantContextualInsight) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ObservabilityAIAssistantContextualInsight, {
    title: _i18n.i18n.translate('xpack.observability.alertDetailContextualInsights.InsightButtonLabel', {
      defaultMessage: 'Help me understand this alert'
    }),
    messages: getAlertContextMessages
  })));
}