"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ALERT_DETAILS_PAGE_ID = void 0;
exports.AlertDetails = AlertDetails;
exports.METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.LOG_DOCUMENT_COUNT_RULE_TYPE_ID = void 0;
exports.getScreenDescription = getScreenDescription;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _dedent = _interopRequireDefault(require("dedent"));
var _alertsUiShared = require("@kbn/alerts-ui-shared");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _kibana_react = require("../../utils/kibana_react");
var _use_fetch_rule = require("../../hooks/use_fetch_rule");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _use_fetch_alert_detail = require("../../hooks/use_fetch_alert_detail");
var _page_title = require("./components/page_title");
var _header_actions = require("./components/header_actions");
var _alert_summary = require("./components/alert_summary");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _get_time_zone = require("../../utils/get_time_zone");
var _is_alert_details_enabled = require("../../utils/is_alert_details_enabled");
var _common = require("../../../common");
var _paths = require("../../../common/locators/paths");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _alert_overview = require("../../components/alert_overview/alert_overview");
var _alert_details_contextual_insights = require("./alert_details_contextual_insights");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_DETAILS_PAGE_ID = exports.ALERT_DETAILS_PAGE_ID = 'alert-details-o11y';
const defaultBreadcrumb = _i18n.i18n.translate('xpack.observability.breadcrumbs.alertDetails', {
  defaultMessage: 'Alert details'
});
const LOG_DOCUMENT_COUNT_RULE_TYPE_ID = exports.LOG_DOCUMENT_COUNT_RULE_TYPE_ID = 'logs.alert.document.count';
const METRIC_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.threshold';
const METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = exports.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID = 'metrics.alert.inventory.threshold';
function AlertDetails() {
  var _alertDetail$formatte2, _alertDetail$formatte3;
  const {
    cases: {
      helpers: {
        canUseCases
      },
      ui: {
        getCasesContext
      }
    },
    http,
    triggersActionsUi: {
      ruleTypeRegistry
    },
    observabilityAIAssistant,
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const {
    ObservabilityPageTemplate,
    config
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    alertId
  } = (0, _reactRouterDom.useParams)();
  const [isLoading, alertDetail] = (0, _use_fetch_alert_detail.useFetchAlertDetail)(alertId);
  const [ruleTypeModel, setRuleTypeModel] = (0, _react.useState)(null);
  const CasesContext = getCasesContext();
  const userCasesPermissions = canUseCases([_common.observabilityFeatureId]);
  const {
    rule
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId: alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_UUID]
  });
  const [summaryFields, setSummaryFields] = (0, _react.useState)();
  const [alertStatus, setAlertStatus] = (0, _react.useState)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  (0, _react.useEffect)(() => {
    if (!alertDetail || !observabilityAIAssistant) {
      return;
    }
    const screenDescription = getScreenDescription(alertDetail);
    return observabilityAIAssistant.service.setScreenContext({
      screenDescription,
      data: [{
        name: 'alert_fields',
        description: 'The fields and values for the alert',
        value: getRelevantAlertFields(alertDetail)
      }]
    });
  }, [observabilityAIAssistant, alertDetail]);
  (0, _react.useEffect)(() => {
    if (alertDetail) {
      var _alertDetail$formatte;
      setRuleTypeModel(ruleTypeRegistry.get(alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID]));
      setAlertStatus(alertDetail === null || alertDetail === void 0 ? void 0 : (_alertDetail$formatte = alertDetail.formatted) === null || _alertDetail$formatte === void 0 ? void 0 : _alertDetail$formatte.fields[_ruleDataUtils.ALERT_STATUS]);
    }
  }, [alertDetail, ruleTypeRegistry]);
  (0, _public.useBreadcrumbs)([{
    href: http.basePath.prepend(_paths.paths.observability.alerts),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    deepLinkId: 'observability-overview:alerts'
  }, {
    text: alertDetail ? (0, _page_title.pageTitleContent)(alertDetail.formatted.fields[_ruleDataUtils.ALERT_RULE_CATEGORY]) : defaultBreadcrumb
  }]);
  const onUntrackAlert = () => {
    setAlertStatus(_ruleDataUtils.ALERT_STATUS_UNTRACKED);
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, null);
  }
  if (!isLoading && !alertDetail) return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "alertDetailsError"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "warning",
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.alertDetails.errorPromptTitle', {
      defaultMessage: 'Unable to load alert details'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability.alertDetails.errorPromptBody', {
      defaultMessage: 'There was an error loading the alert details.'
    }))
  }));
  const AlertDetailsAppSection = ruleTypeModel ? ruleTypeModel.alertDetailsAppSection : null;
  const timeZone = (0, _get_time_zone.getTimeZone)(uiSettings);
  const OVERVIEW_TAB_ID = 'overview';
  const METADATA_TAB_ID = 'metadata';
  const overviewTab = alertDetail ? AlertDetailsAppSection &&
  /*
  when feature flag is enabled, show alert details page with customized overview tab, 
  otherwise show default overview tab 
  */
  (0, _is_alert_details_enabled.isAlertDetailsEnabledPerApp)(alertDetail.formatted, config) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_alert_summary.AlertSummary, {
    alertSummaryFields: summaryFields
  }), /*#__PURE__*/_react.default.createElement(_alert_details_contextual_insights.AlertDetailContextualInsights, {
    alert: alertDetail
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), rule && alertDetail.formatted && /*#__PURE__*/_react.default.createElement(AlertDetailsAppSection, {
    alert: alertDetail.formatted,
    rule: rule,
    timeZone: timeZone,
    setAlertSummaryFields: setSummaryFields,
    ruleLink: http.basePath.prepend(_paths.paths.observability.ruleDetails(rule.id))
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "overviewTabPanel",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_alert_details_contextual_insights.AlertDetailContextualInsights, {
    alert: alertDetail
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_alert_overview.AlertOverview, {
    alert: alertDetail.formatted
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const metadataTab = (alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.raw) && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    "data-test-subj": "metadataTabPanel",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_alertsUiShared.AlertFieldsTable, {
    alert: alertDetail.raw
  }));
  const tabs = [{
    id: OVERVIEW_TAB_ID,
    name: _i18n.i18n.translate('xpack.observability.alertDetails.tab.overviewLabel', {
      defaultMessage: 'Overview'
    }),
    'data-test-subj': 'overviewTab',
    content: overviewTab
  }, {
    id: METADATA_TAB_ID,
    name: _i18n.i18n.translate('xpack.observability.alertDetails.tab.metadataLabel', {
      defaultMessage: 'Metadata'
    }),
    'data-test-subj': 'metadataTab',
    content: metadataTab
  }];
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
        alert: (_alertDetail$formatte2 = alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted) !== null && _alertDetail$formatte2 !== void 0 ? _alertDetail$formatte2 : null,
        alertStatus: alertStatus,
        dataTestSubj: (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId) || 'alertDetailsPageTitle'
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(CasesContext, {
        owner: [_common.observabilityFeatureId],
        permissions: userCasesPermissions,
        features: {
          alerts: {
            sync: false
          }
        }
      }, /*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        alert: (_alertDetail$formatte3 = alertDetail === null || alertDetail === void 0 ? void 0 : alertDetail.formatted) !== null && _alertDetail$formatte3 !== void 0 ? _alertDetail$formatte3 : null,
        alertStatus: alertStatus,
        onUntrackAlert: onUntrackAlert
      }))],
      bottomBorder: false
    },
    pageSectionProps: {
      paddingSize: 'none',
      css: (0, _react2.css)`
          padding: 0 ${euiTheme.size.l} ${euiTheme.size.l} ${euiTheme.size.l};
        `
    },
    "data-test-subj": "alertDetails"
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "alertDetailsTabbedContent",
    tabs: tabs
  }));
}
function getScreenDescription(alertDetail) {
  const alertState = alertDetail.formatted.active ? 'active' : 'recovered';
  const alertStarted = new Date(alertDetail.formatted.start).toISOString();
  const alertUpdated = new Date(alertDetail.formatted.lastUpdated).toISOString();
  return (0, _dedent.default)(`The user is looking at an ${alertState} alert. It started at ${alertStarted}, and was last updated at ${alertUpdated}.

  ${alertDetail.formatted.reason ? `The reason given for the alert is ${alertDetail.formatted.reason}.` : ''}

  Use the following alert fields as background information for generating a response. Do not list them as bullet points in the response.
  ${Object.entries(getRelevantAlertFields(alertDetail)).map(([key, value]) => `${key}: ${JSON.stringify(value)}`).join('\n')}  
  `);
}
function getRelevantAlertFields(alertDetail) {
  return (0, _lodash.omit)(alertDetail.formatted.fields, ['kibana.alert.rule.revision', 'kibana.alert.rule.execution.uuid', 'kibana.alert.flapping_history', 'kibana.alert.uuid', 'kibana.alert.rule.uuid', 'event.action', 'event.kind', 'kibana.alert.rule.tags', 'kibana.alert.maintenance_window_ids', 'kibana.alert.consecutive_matches']);
}