"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetAvailableRulesWithDescriptions = useGetAvailableRulesWithDescriptions;
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _react = require("react");
var _kibana_react = require("../utils/kibana_react");
var _use_get_filtered_rule_types = require("./use_get_filtered_rule_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetAvailableRulesWithDescriptions() {
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    triggersActionsUi: {
      ruleTypeRegistry
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    ruleTypesState: {
      data: ruleTypes
    }
  } = (0, _public.useLoadRuleTypesQuery)({
    filteredRuleTypes
  });
  return (0, _react.useMemo)(() => {
    const ruleTypesFromRuleTypeRegistry = ruleTypeRegistry.list();
    return Array.from(ruleTypes).map(([id, rule]) => {
      var _ruleTypesFromRuleTyp;
      return {
        id,
        name: rule.name,
        description: ((_ruleTypesFromRuleTyp = ruleTypesFromRuleTypeRegistry.find(f => f.id === id)) === null || _ruleTypesFromRuleTyp === void 0 ? void 0 : _ruleTypesFromRuleTyp.description) || ''
      };
    });
  }, [ruleTypeRegistry, ruleTypes]);
}