"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreateRule = useCreateRule;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/alerting-plugin/common");
var _uuid = require("uuid");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useCreateRule() {
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const createRule = (0, _reactQuery.useMutation)(['createRule'], ({
    rule
  }) => {
    try {
      const ruleId = (0, _uuid.v4)();
      const body = JSON.stringify(rule);
      return http.post(`${_common.BASE_ALERTING_API_PATH}/rule/${ruleId}`, {
        body
      });
    } catch (e) {
      throw new Error(`Unable to create rule: ${e}`);
    }
  }, {
    onError: _err => {
      toasts.addDanger(_i18n.i18n.translate('xpack.observability.rules.createRule.errorNotification.descriptionText', {
        defaultMessage: 'Failed to create rule'
      }));
    },
    onSuccess: () => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.rules.createRule.successNotification.descriptionText', {
        defaultMessage: 'Rule created'
      }));
    }
  });
  return createRule;
}