"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Expressions;
exports.defaultExpression = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _public = require("@kbn/stack-alerts-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _kibana_react = require("../../utils/kibana_react");
var _types = require("../../../common/custom_threshold_rule/types");
var _expression_row = require("./components/expression_row");
var _group_by = require("./components/group_by");
var _rule_condition_chart = require("./components/rule_condition_chart/rule_condition_chart");
var _get_search_configuration = require("./helpers/get_search_configuration");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FILTER_TYPING_DEBOUNCE_MS = 500;
const defaultExpression = exports.defaultExpression = {
  comparator: _types.Comparator.GT,
  metrics: [{
    name: 'A',
    aggType: _types.Aggregators.COUNT
  }],
  threshold: [100],
  timeSize: 1,
  timeUnit: 'm'
};

// eslint-disable-next-line import/no-default-export
function Expressions(props) {
  var _ruleParams$searchCon4, _ruleParams$searchCon5, _ruleParams$searchCon6;
  const {
    setRuleParams,
    ruleParams,
    errors,
    metadata,
    onChangeMetaData
  } = props;
  const {
    data,
    dataViews,
    dataViewEditor,
    docLinks,
    unifiedSearch: {
      ui: {
        SearchBar
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const [timeSize, setTimeSize] = (0, _react.useState)(1);
  const [timeUnit, setTimeUnit] = (0, _react.useState)('m');
  const [dataView, setDataView] = (0, _react.useState)();
  const [dataViewTimeFieldError, setDataViewTimeFieldError] = (0, _react.useState)();
  const [searchSource, setSearchSource] = (0, _react.useState)();
  const [paramsError, setParamsError] = (0, _react.useState)();
  const [paramsWarning, setParamsWarning] = (0, _react.useState)();
  const derivedIndexPattern = (0, _react.useMemo)(() => ({
    fields: (dataView === null || dataView === void 0 ? void 0 : dataView.fields) || [],
    title: (dataView === null || dataView === void 0 ? void 0 : dataView.getIndexPattern()) || 'unknown-index'
  }), [dataView]);
  (0, _react.useEffect)(() => {
    const initSearchSource = async () => {
      let initialSearchConfiguration = ruleParams.searchConfiguration;
      if (!ruleParams.searchConfiguration || !ruleParams.searchConfiguration.index) {
        var _metadata$currentOpti;
        if (metadata !== null && metadata !== void 0 && (_metadata$currentOpti = metadata.currentOptions) !== null && _metadata$currentOpti !== void 0 && _metadata$currentOpti.searchConfiguration) {
          var _ruleParams$searchCon, _ruleParams$searchCon2;
          initialSearchConfiguration = {
            query: {
              query: (_ruleParams$searchCon = (_ruleParams$searchCon2 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon2 === void 0 ? void 0 : _ruleParams$searchCon2.query) !== null && _ruleParams$searchCon !== void 0 ? _ruleParams$searchCon : '',
              language: 'kuery'
            },
            ...metadata.currentOptions.searchConfiguration
          };
        } else {
          const newSearchSource = data.search.searchSource.createEmpty();
          newSearchSource.setField('query', data.query.queryString.getDefaultQuery());
          const defaultDataView = await data.dataViews.getDefaultDataView();
          if (defaultDataView) {
            newSearchSource.setField('index', defaultDataView);
            setDataView(defaultDataView);
          }
          initialSearchConfiguration = (0, _get_search_configuration.getSearchConfiguration)(newSearchSource.getSerializedFields(), setParamsWarning);
        }
      }
      try {
        var _ruleParams$searchCon3;
        const createdSearchSource = await data.search.searchSource.create(initialSearchConfiguration);
        setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
          ...initialSearchConfiguration,
          ...(((_ruleParams$searchCon3 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon3 === void 0 ? void 0 : _ruleParams$searchCon3.query) && {
            query: ruleParams.searchConfiguration.query
          })
        }, setParamsWarning));
        setSearchSource(createdSearchSource);
        setDataView(createdSearchSource.getField('index'));
        if (createdSearchSource.getField('index')) {
          var _createdSearchSource$;
          const timeFieldName = (_createdSearchSource$ = createdSearchSource.getField('index')) === null || _createdSearchSource$ === void 0 ? void 0 : _createdSearchSource$.timeFieldName;
          if (!timeFieldName) {
            setDataViewTimeFieldError(_i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.dataViewError.noTimestamp', {
              defaultMessage: 'The selected data view does not have a timestamp field, please select another data view.'
            }));
          } else {
            setDataViewTimeFieldError(undefined);
          }
        } else {
          setDataViewTimeFieldError(undefined);
        }
      } catch (error) {
        setParamsError(error);
      }
    };
    initSearchSource();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [data.search.searchSource, data.dataViews, dataView]);
  (0, _react.useEffect)(() => {
    if (ruleParams.criteria && ruleParams.criteria.length) {
      setTimeSize(ruleParams.criteria[0].timeSize);
      setTimeUnit(ruleParams.criteria[0].timeUnit);
    } else {
      preFillCriteria();
    }
    if (!ruleParams.groupBy) {
      preFillGroupBy();
    }
    if (typeof ruleParams.alertOnNoData === 'undefined') {
      setRuleParams('alertOnNoData', true);
    }
    if (typeof ruleParams.alertOnGroupDisappear === 'undefined') {
      preFillAlertOnGroupDisappear();
    }
  }, [metadata]); // eslint-disable-line react-hooks/exhaustive-deps

  const onSelectDataView = (0, _react.useCallback)(newDataView => {
    const ruleCriteria = (ruleParams.criteria ? ruleParams.criteria.slice() : []).map(criterion => {
      var _criterion$metrics;
      (_criterion$metrics = criterion.metrics) === null || _criterion$metrics === void 0 ? void 0 : _criterion$metrics.forEach(metric => {
        metric.field = undefined;
      });
      return criterion;
    });
    setRuleParams('criteria', ruleCriteria);
    searchSource === null || searchSource === void 0 ? void 0 : searchSource.setParent(undefined).setField('index', newDataView);
    setRuleParams('searchConfiguration', searchSource && (0, _get_search_configuration.getSearchConfiguration)(searchSource.getSerializedFields(), setParamsWarning));
    setDataView(newDataView);
  }, [ruleParams.criteria, searchSource, setRuleParams]);
  const updateParams = (0, _react.useCallback)((id, e) => {
    const ruleCriteria = ruleParams.criteria ? ruleParams.criteria.slice() : [];
    ruleCriteria[id] = e;
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);
  const addExpression = (0, _react.useCallback)(() => {
    var _ruleParams$criteria;
    const ruleCriteria = ((_ruleParams$criteria = ruleParams.criteria) === null || _ruleParams$criteria === void 0 ? void 0 : _ruleParams$criteria.slice()) || [];
    ruleCriteria.push({
      ...defaultExpression,
      timeSize: timeSize !== null && timeSize !== void 0 ? timeSize : defaultExpression.timeSize,
      timeUnit: timeUnit !== null && timeUnit !== void 0 ? timeUnit : defaultExpression.timeUnit
    });
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria, timeSize, timeUnit]);
  const removeExpression = (0, _react.useCallback)(id => {
    var _ruleParams$criteria2;
    const ruleCriteria = ((_ruleParams$criteria2 = ruleParams.criteria) === null || _ruleParams$criteria2 === void 0 ? void 0 : _ruleParams$criteria2.filter((_, index) => index !== id)) || [];
    setRuleParams('criteria', ruleCriteria);
  }, [setRuleParams, ruleParams.criteria]);
  const onFilterChange = (0, _react.useCallback)(({
    query
  }) => {
    setParamsWarning(undefined);
    setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
      ...ruleParams.searchConfiguration,
      query
    }, setParamsWarning));
  }, [setRuleParams, ruleParams.searchConfiguration]);

  /* eslint-disable-next-line react-hooks/exhaustive-deps */
  const debouncedOnFilterChange = (0, _react.useCallback)((0, _lodash.debounce)(onFilterChange, FILTER_TYPING_DEBOUNCE_MS), [onFilterChange]);
  const onGroupByChange = (0, _react.useCallback)(group => {
    setRuleParams('groupBy', group && group.length ? group : '');
  }, [setRuleParams]);
  const emptyError = (0, _react.useMemo)(() => {
    return {
      aggField: [],
      timeSizeUnit: [],
      timeWindowSize: []
    };
  }, []);
  const updateTimeSize = (0, _react.useCallback)(ts => {
    var _ruleParams$criteria3;
    const ruleCriteria = ((_ruleParams$criteria3 = ruleParams.criteria) === null || _ruleParams$criteria3 === void 0 ? void 0 : _ruleParams$criteria3.map(c => ({
      ...c,
      timeSize: ts
    }))) || [];
    setTimeSize(ts || undefined);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const updateTimeUnit = (0, _react.useCallback)(tu => {
    var _ruleParams$criteria4;
    const ruleCriteria = ((_ruleParams$criteria4 = ruleParams.criteria) === null || _ruleParams$criteria4 === void 0 ? void 0 : _ruleParams$criteria4.map(c => ({
      ...c,
      timeUnit: tu
    }))) || [];
    setTimeUnit(tu);
    setRuleParams('criteria', ruleCriteria);
  }, [ruleParams.criteria, setRuleParams]);
  const preFillCriteria = (0, _react.useCallback)(() => {
    var _md$currentOptions, _md$currentOptions$cr;
    const md = metadata;
    if (md !== null && md !== void 0 && (_md$currentOptions = md.currentOptions) !== null && _md$currentOptions !== void 0 && (_md$currentOptions$cr = _md$currentOptions.criteria) !== null && _md$currentOptions$cr !== void 0 && _md$currentOptions$cr.length) {
      const {
        timeSize: prefillTimeSize,
        timeUnit: prefillTimeUnit
      } = md.currentOptions.criteria[0];
      if (prefillTimeSize) setTimeSize(prefillTimeSize);
      if (prefillTimeUnit) setTimeUnit(prefillTimeUnit);
      setRuleParams('criteria', md.currentOptions.criteria.map(criterion => ({
        ...defaultExpression,
        ...criterion
      })));
    } else {
      setRuleParams('criteria', [defaultExpression]);
    }
  }, [metadata, setRuleParams]);
  const preFillGroupBy = (0, _react.useCallback)(() => {
    var _md$currentOptions2;
    const md = metadata;
    if (md && (_md$currentOptions2 = md.currentOptions) !== null && _md$currentOptions2 !== void 0 && _md$currentOptions2.groupBy) {
      setRuleParams('groupBy', md.currentOptions.groupBy);
    }
  }, [metadata, setRuleParams]);
  const preFillAlertOnGroupDisappear = (0, _react.useCallback)(() => {
    var _md$currentOptions3;
    const md = metadata;
    if (md && typeof ((_md$currentOptions3 = md.currentOptions) === null || _md$currentOptions3 === void 0 ? void 0 : _md$currentOptions3.alertOnGroupDisappear) !== 'undefined') {
      setRuleParams('alertOnGroupDisappear', md.currentOptions.alertOnGroupDisappear);
    } else {
      setRuleParams('alertOnGroupDisappear', true);
    }
  }, [metadata, setRuleParams]);
  const hasGroupBy = (0, _react.useMemo)(() => ruleParams.groupBy && ruleParams.groupBy.length > 0, [ruleParams.groupBy]);

  // Test to see if any of the group fields in groupBy are already filtered down to a single
  // group by the filterQuery. If this is the case, then a groupBy is unnecessary, as it would only
  // ever produce one group instance
  const groupByFilterTestPatterns = (0, _react.useMemo)(() => {
    if (!ruleParams.groupBy) return null;
    const groups = !Array.isArray(ruleParams.groupBy) ? [ruleParams.groupBy] : ruleParams.groupBy;
    return groups.map(group => ({
      groupName: group,
      pattern: new RegExp(`{"match(_phrase)?":{"${group}":"(.*?)"}}`)
    }));
  }, [ruleParams.groupBy]);
  const redundantFilterGroupBy = (0, _react.useMemo)(() => {
    const {
      filterQuery
    } = ruleParams;
    if (typeof filterQuery !== 'string' || !groupByFilterTestPatterns) return [];
    return groupByFilterTestPatterns.map(({
      groupName,
      pattern
    }) => {
      if (pattern.test(filterQuery)) {
        return groupName;
      }
    }).filter(g => typeof g === 'string');
  }, [ruleParams, groupByFilterTestPatterns]);
  if (paramsError) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      iconType: "warning",
      "data-test-subj": "thresholdRuleExpressionError"
    }, /*#__PURE__*/_react.default.createElement("p", null, paramsError.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'm'
    }));
  }
  if (!searchSource) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "xl"
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  const placeHolder = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.searchBar.placeholder', {
    defaultMessage: 'Search for observability data… (e.g. host.name:host-1)'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!paramsWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.warning.title', {
      defaultMessage: 'Warning'
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "thresholdRuleExpressionWarning"
  }, paramsWarning), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.selectDataViewPrompt",
    defaultMessage: "Select a data view"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_public.DataViewSelectPopover, {
    dependencies: {
      dataViews,
      dataViewEditor
    },
    dataView: dataView,
    metadata: {
      adHocDataViewList: (metadata === null || metadata === void 0 ? void 0 : metadata.adHocDataViewList) || []
    },
    onSelectDataView: onSelectDataView,
    onChangeMetaData: ({
      adHocDataViewList
    }) => {
      onChangeMetaData({
        ...metadata,
        adHocDataViewList
      });
    }
  }), dataViewTimeFieldError && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "thresholdRuleDataViewErrorNoTimestamp"
  }, dataViewTimeFieldError), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.defineTextQueryPrompt",
    defaultMessage: "Define query filter (optional)"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: "Custom threshold rule",
    iconType: "search",
    placeholder: placeHolder,
    indexPatterns: dataView ? [dataView] : undefined,
    showQueryInput: true,
    showQueryMenu: false,
    showFilterBar: !!((_ruleParams$searchCon4 = ruleParams.searchConfiguration) !== null && _ruleParams$searchCon4 !== void 0 && _ruleParams$searchCon4.filter),
    showDatePicker: false,
    showSubmitButton: false,
    displayStyle: "inPage",
    onQueryChange: debouncedOnFilterChange,
    onQuerySubmit: onFilterChange,
    dataTestSubj: "thresholdRuleUnifiedSearchBar",
    query: (_ruleParams$searchCon5 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon5 === void 0 ? void 0 : _ruleParams$searchCon5.query,
    filters: (_ruleParams$searchCon6 = ruleParams.searchConfiguration) === null || _ruleParams$searchCon6 === void 0 ? void 0 : _ruleParams$searchCon6.filter,
    onFiltersUpdated: filter => {
      setRuleParams('searchConfiguration', (0, _get_search_configuration.getSearchConfiguration)({
        ...ruleParams.searchConfiguration,
        filter
      }, setParamsWarning));
    }
  }), errors.filterQuery && /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
    "data-test-subj": "thresholdRuleDataViewErrorNoTimestamp"
  }, errors.filterQuery), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), ruleParams.criteria && ruleParams.criteria.map((e, idx) => {
    return /*#__PURE__*/_react.default.createElement("div", {
      key: idx
    }, idx > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "s"
    }), /*#__PURE__*/_react.default.createElement(_expression_row.ExpressionRow, {
      canDelete: ruleParams.criteria && ruleParams.criteria.length > 1 || false,
      fields: derivedIndexPattern.fields,
      remove: removeExpression,
      addExpression: addExpression,
      key: idx // idx's don't usually make good key's but here the index has semantic meaning
      ,
      expressionId: idx,
      setRuleParams: updateParams,
      errors: errors[idx] || emptyError,
      expression: e || {},
      dataView: derivedIndexPattern,
      title: ruleParams.criteria.length === 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.alertFlyout.setConditions",
        defaultMessage: "Set rule conditions"
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule.alertFlyout.condition",
        defaultMessage: "Condition {conditionNumber}",
        values: {
          conditionNumber: idx + 1
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_rule_condition_chart.RuleConditionChart, {
      metricExpression: e,
      dataView: dataView,
      searchConfiguration: ruleParams.searchConfiguration,
      groupBy: ruleParams.groupBy,
      error: errors[idx] || emptyError,
      timeRange: {
        from: `now-${(timeSize !== null && timeSize !== void 0 ? timeSize : 1) * 20}${timeUnit}`,
        to: 'now'
      }
    })));
  }), /*#__PURE__*/_react.default.createElement(_public2.ForLastExpression, {
    timeWindowSize: timeSize,
    timeWindowUnit: timeUnit,
    errors: emptyError,
    onChangeWindowSize: updateTimeSize,
    onChangeWindowUnit: updateTimeUnit,
    display: "fullWidth"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "thresholdRuleExpressionsAddConditionButton",
    color: "primary",
    iconSide: "left",
    flush: "left",
    iconType: "plusInCircleFilled",
    onClick: addExpression
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.addCondition",
    defaultMessage: "Add condition"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.createAlertPerText', {
      defaultMessage: 'Group alerts by (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.createAlertPerHelpText', {
      defaultMessage: 'Create an alert for every unique value. For example: "host.id" or "cloud.region".'
    }),
    fullWidth: true,
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_group_by.GroupBy, {
    onChange: onGroupByChange,
    fields: derivedIndexPattern.fields,
    options: {
      groupBy: ruleParams.groupBy || null
    },
    errorOptions: redundantFilterGroupBy
  })), redundantFilterGroupBy.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.alertPerRedundantFilterError",
    defaultMessage: "This rule may alert on {matchedGroups} less than expected, because the filter query contains a match for {groupCount, plural, one {this field} other {these fields}}. For more information, refer to {filteringAndGroupingLink}.",
    values: {
      matchedGroups: /*#__PURE__*/_react.default.createElement("strong", null, redundantFilterGroupBy.join(', ')),
      groupCount: redundantFilterGroupBy.length,
      filteringAndGroupingLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "thresholdRuleExpressionsTheDocsLink",
        href: `${docLinks.links.observability.metricsThreshold}#filtering-and-grouping`
      }, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertPerRedundantFilterError.docsLink', {
        defaultMessage: 'the docs'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "metrics-alert-group-disappear-toggle",
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.alertOnGroupDisappear', {
      defaultMessage: 'Alert me if a group stops reporting data'
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.groupDisappearHelpText', {
        defaultMessage: 'Enable this to trigger the action if a previously detected group begins to report no results. This is not recommended for dynamically scaling infrastructures that may rapidly start and stop nodes automatically.'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: "subdued"
    }))),
    disabled: !hasGroupBy,
    checked: Boolean(hasGroupBy && ruleParams.alertOnGroupDisappear),
    onChange: e => setRuleParams('alertOnGroupDisappear', e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
}