"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricRowWithAgg = MetricRowWithAgg;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../../../common/custom_threshold_rule/types");
var _kuery_bar = require("../../../rule_kql_filter/kuery_bar");
var _closable_popover_title = require("../closable_popover_title");
var _metric_row_controls = require("./metric_row_controls");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_COUNT_FILTER_TITLE = _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.defaultCountFilterTitle', {
  defaultMessage: 'all documents'
});
function MetricRowWithAgg({
  name,
  aggType = _types.Aggregators.COUNT,
  field,
  onDelete,
  dataView,
  filter,
  disableDelete,
  fields,
  aggregationTypes,
  onChange,
  errors
}) {
  const handleDelete = (0, _react.useCallback)(() => {
    onDelete(name);
  }, [name, onDelete]);
  const [aggTypePopoverOpen, setAggTypePopoverOpen] = (0, _react.useState)(false);
  const fieldOptions = (0, _react.useMemo)(() => fields.reduce((acc, fieldValue) => {
    if (aggType && aggregationTypes[aggType].validNormalizedTypes.includes(fieldValue.normalizedType)) {
      acc.push({
        label: fieldValue.name
      });
    }
    return acc;
  }, []), [fields, aggregationTypes, aggType]);
  const handleFieldChange = (0, _react.useCallback)(selectedOptions => {
    onChange({
      name,
      field: selectedOptions.length && selectedOptions[0].label || undefined,
      aggType
    });
  }, [name, aggType, onChange]);
  const handleAggChange = (0, _react.useCallback)(customAggType => {
    onChange({
      name,
      field: customAggType === _types.Aggregators.COUNT ? undefined : field,
      aggType: customAggType
    });
  }, [name, field, onChange]);
  const handleFilterChange = (0, _react.useCallback)(filterString => {
    onChange({
      name,
      filter: filterString,
      aggType
    });
  }, [name, aggType, onChange]);
  const isAggInvalid = (0, _lodash.get)(errors, ['metrics', name, 'aggType']) != null;
  const isFieldInvalid = (0, _lodash.get)(errors, ['metrics', name, 'field']) != null || !field;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        alignItems: "center"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        css: {
          paddingTop: 2,
          paddingBottom: 2
        }
      }, _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.aggregationLabel', {
        defaultMessage: 'Aggregation {name}',
        values: {
          name
        }
      })), !disableDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_metric_row_controls.MetricRowControls, {
        onDelete: handleDelete,
        disableDelete: disableDelete
      })))
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "data-test-subj": "aggregationName",
      description: aggregationTypes[aggType].text,
      value: aggType === _types.Aggregators.COUNT ? filter || DEFAULT_COUNT_FILTER_TITLE : field,
      isActive: aggTypePopoverOpen,
      display: "columns",
      onClick: () => {
        setAggTypePopoverOpen(true);
      },
      isInvalid: aggType !== _types.Aggregators.COUNT && !field
    })),
    isOpen: aggTypePopoverOpen,
    closePopover: () => {
      setAggTypePopoverOpen(false);
    },
    display: "block",
    ownFocus: true,
    anchorPosition: 'downLeft',
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_closable_popover_title.ClosablePopoverTitle, {
    onClose: () => setAggTypePopoverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.aggregationLabel",
    defaultMessage: "Aggregation {name}",
    values: {
      name
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.aggregationType', {
      defaultMessage: 'Aggregation type'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "aggregationTypeSelect",
    id: "aggTypeField",
    value: aggType,
    fullWidth: true,
    onChange: e => {
      handleAggChange(e.target.value);
    },
    options: Object.values(aggregationTypes).map(({
      text,
      value
    }) => {
      return {
        text,
        value
      };
    }),
    isInvalid: isAggInvalid
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 300
    }
  }, aggType === _types.Aggregators.COUNT ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.filterLabel', {
      defaultMessage: 'KQL Filter {name}',
      values: {
        name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_kuery_bar.RuleFlyoutKueryBar, {
    placeholder: ' ',
    derivedIndexPattern: dataView,
    onChange: handleFilterChange,
    onSubmit: handleFilterChange,
    value: filter
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.customThreshold.rule.alertFlyout.customEquationEditor.fieldLabel', {
      defaultMessage: 'Field name'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    isInvalid: isFieldInvalid,
    singleSelection: {
      asPlainText: true
    },
    options: fieldOptions,
    selectedOptions: field ? [{
      label: field
    }] : [],
    onChange: handleFieldChange
  }))))))));
}