"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialAnalysisStart = exports.getDeviationMax = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDeviationMax = ({
  alertStart,
  intervalFactor,
  alertEnd
}) => {
  if (alertEnd) {
    return alertEnd.clone().subtract(1 * intervalFactor, 'minutes').valueOf();
  } else if (alertStart.clone().add(10 * intervalFactor, 'minutes').isAfter((0, _moment.default)(new Date()))) {
    return (0, _moment.default)(new Date()).valueOf();
  } else {
    return alertStart.clone().add(10 * intervalFactor, 'minutes').valueOf();
  }
};
exports.getDeviationMax = getDeviationMax;
const getInitialAnalysisStart = args => {
  const {
    alertStart,
    intervalFactor
  } = args;
  return {
    baselineMin: alertStart.clone().subtract(13 * intervalFactor, 'minutes').valueOf(),
    baselineMax: alertStart.clone().subtract(2 * intervalFactor, 'minutes').valueOf(),
    deviationMin: alertStart.clone().subtract(1 * intervalFactor, 'minutes').valueOf(),
    deviationMax: getDeviationMax(args)
  };
};
exports.getInitialAnalysisStart = getInitialAnalysisStart;