"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Groups = Groups;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-shared-plugin/common");
var _kibana_react = require("../../../../utils/kibana_react");
var _get_alert_source_links = require("../../../../../common/custom_threshold_rule/helpers/get_alert_source_links");
var _get_apm_app_url = require("../../../../../common/custom_threshold_rule/get_apm_app_url");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Groups({
  groups,
  timeRange
}) {
  var _groups$find;
  const {
    http: {
      basePath: {
        prepend
      }
    },
    share: {
      url: {
        locators
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const [sourceLinks, setSourceLinks] = (0, _react.useState)({});
  const serviceName = (_groups$find = groups.find(group => group.field === _common.SERVICE_NAME)) === null || _groups$find === void 0 ? void 0 : _groups$find.value;
  (0, _react.useEffect)(() => {
    if (!groups) return;
    let links = {};
    groups.map(group => {
      const link = (0, _get_alert_source_links.generateSourceLink)(group, timeRange, prepend, serviceName, locators.get(_get_apm_app_url.APM_APP_LOCATOR_ID));
      links = {
        ...links,
        [group.field]: link
      };
    });
    setSourceLinks(links);
  }, [groups, locators, prepend, serviceName, timeRange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, groups && groups.map(group => {
    return /*#__PURE__*/_react.default.createElement("span", {
      key: group.field
    }, group.field, ":", ' ', sourceLinks[group.field] ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "o11yCustomThresholdAlertSourceLink",
      href: sourceLinks[group.field]
    }, group.value) : /*#__PURE__*/_react.default.createElement("strong", null, group.value), /*#__PURE__*/_react.default.createElement("br", null));
  }));
}