"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertHistoryChart = AlertHistoryChart;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _formatters = require("../../../../../common/utils/formatters");
var _get_group = require("../../../../../common/custom_threshold_rule/helpers/get_group");
var _kibana_react = require("../../../../utils/kibana_react");
var _rule_condition_chart = require("../rule_condition_chart/rule_condition_chart");
var _generate_chart_title_and_tooltip = require("./helpers/generate_chart_title_and_tooltip");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_INTERVAL = '1d';
const SERIES_TYPE = 'bar_stacked';
const dateRange = {
  from: 'now-30d',
  to: 'now'
};
function AlertHistoryChart({
  rule,
  dataView,
  alert
}) {
  const {
    http,
    notifications
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const ruleParams = rule.params;
  const groups = alert.fields[_ruleDataUtils.ALERT_GROUP];
  const instanceId = alert.fields[_ruleDataUtils.ALERT_INSTANCE_ID];
  const featureIds = [rule.consumer];
  const options = rule.params.criteria.map((criterion, index) => {
    const {
      title,
      tooltip
    } = (0, _generate_chart_title_and_tooltip.generateChartTitleAndTooltip)(criterion, 27);
    return {
      text: title,
      title: tooltip
    };
  });
  const [selectedCriterion, setSelectedCriterion] = (0, _react.useState)(rule.params.criteria[0]);
  const {
    data: {
      histogramTriggeredAlerts,
      avgTimeToRecoverUS,
      totalTriggeredAlerts
    },
    isLoading,
    isError
  } = (0, _observabilityAlertDetails.useAlertsHistory)({
    http,
    featureIds,
    ruleId: rule.id,
    dateRange,
    instanceId
  });
  if (isError) {
    notifications === null || notifications === void 0 ? void 0 : notifications.toasts.addDanger({
      title: _i18n.i18n.translate('xpack.observability.customThreshold.alertHistory.error.toastTitle', {
        defaultMessage: 'Alerts history chart error'
      }),
      text: _i18n.i18n.translate('xpack.observability.customThreshold.alertHistory.error.toastDescription', {
        defaultMessage: `An error occurred when fetching alert history chart data`
      })
    });
  }
  const annotations = (histogramTriggeredAlerts === null || histogramTriggeredAlerts === void 0 ? void 0 : histogramTriggeredAlerts.filter(annotation => annotation.doc_count > 0).map(annotation => {
    return {
      type: 'manual',
      id: (0, _uuid.v4)(),
      label: String(annotation.doc_count),
      key: {
        type: 'point_in_time',
        timestamp: (0, _moment.default)(new Date(annotation.key_as_string)).toISOString()
      },
      lineWidth: 2,
      color: euiTheme.colors.danger,
      icon: 'alert',
      textVisibility: true
    };
  })) || [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "AlertDetails"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.customThreshold.alertHistory.chartTitle', {
    defaultMessage: 'Alerts history'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability.customThreshold.alertHistory.last30days', {
    defaultMessage: 'Last 30 days'
  })))), rule.params.criteria.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "o11yAlertHistoryChartSelect",
    options: options,
    onChange: e => {
      var _options$map$indexOf;
      return setSelectedCriterion(rule.params.criteria[(_options$map$indexOf = options.map(option => option.text).indexOf(e.target.value)) !== null && _options$map$indexOf !== void 0 ? _options$map$indexOf : 0]);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : totalTriggeredAlerts || '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability.customThreshold.alertHistory.alertsTriggered', {
    defaultMessage: 'Alerts triggered'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : avgTimeToRecoverUS ? (0, _formatters.convertTo)({
    unit: 'minutes',
    microseconds: avgTimeToRecoverUS,
    extended: true
  }).formatted : '-')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.observability.customThreshold.alertHistory.avgTimeToRecover', {
    defaultMessage: 'Avg time to recover'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_rule_condition_chart.RuleConditionChart, {
    additionalFilters: (0, _get_group.getGroupFilters)(groups),
    annotations: annotations,
    chartOptions: {
      // For alert details page, the series type needs to be changed to 'bar_stacked'
      // due to https://github.com/elastic/elastic-charts/issues/2323
      seriesType: SERIES_TYPE,
      interval: DEFAULT_INTERVAL
    },
    dataView: dataView,
    groupBy: ruleParams.groupBy,
    metricExpression: selectedCriterion,
    searchConfiguration: ruleParams.searchConfiguration,
    timeRange: dateRange
  }));
}