"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloAlertsTableConfiguration = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _public = require("@kbn/observability-shared-plugin/public");
var _render_cell_value = require("../common/render_cell_value");
var _use_get_alert_flyout_components = require("../../alerts_flyout/use_get_alert_flyout_components");
var _default_columns = require("./default_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloAlertsTableConfiguration = observabilityRuleTypeRegistry => ({
  id: _public.SLO_ALERTS_TABLE_CONFIG_ID,
  cases: {
    featureId: _public.casesFeatureId,
    owner: [_public.observabilityFeatureId]
  },
  columns: _default_columns.columns,
  getRenderCellValue: _render_cell_value.getRenderCellValue,
  sort: [{
    [_ruleDataUtils.ALERT_DURATION]: {
      order: 'desc'
    }
  }],
  useInternalFlyout: () => {
    const {
      header,
      body,
      footer
    } = (0, _use_get_alert_flyout_components.useGetAlertFlyoutComponents)(observabilityRuleTypeRegistry);
    return {
      header,
      body,
      footer
    };
  }
});
exports.getSloAlertsTableConfiguration = getSloAlertsTableConfiguration;