"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAlertsTableConfiguration = void 0;
var _get_alerts_page_table_configuration = require("./alerts/get_alerts_page_table_configuration");
var _get_rule_details_table_configuration = require("./rule_details/get_rule_details_table_configuration");
var _get_slo_alerts_table_configuration = require("./slo/get_slo_alerts_table_configuration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerAlertsTableConfiguration = (alertTableConfigRegistry, observabilityRuleTypeRegistry, config) => {
  // Alert page
  const alertsPageAlertsTableConfig = (0, _get_alerts_page_table_configuration.getAlertsPageTableConfiguration)(observabilityRuleTypeRegistry, config);
  alertTableConfigRegistry.register(alertsPageAlertsTableConfig);

  // Rule details page
  const ruleDetailsAlertsTableConfig = (0, _get_rule_details_table_configuration.getRuleDetailsTableConfiguration)(observabilityRuleTypeRegistry, config);
  alertTableConfigRegistry.register(ruleDetailsAlertsTableConfig);

  // SLO
  const sloAlertsTableConfig = (0, _get_slo_alerts_table_configuration.getSloAlertsTableConfiguration)(observabilityRuleTypeRegistry);
  alertTableConfigRegistry.register(sloAlertsTableConfig);
};
exports.registerAlertsTableConfiguration = registerAlertsTableConfiguration;