"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsPageTableConfiguration = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("../../../../common");
var _alert_actions = require("../../../pages/alerts/components/alert_actions");
var _use_get_alert_flyout_components = require("../../alerts_flyout/use_get_alert_flyout_components");
var _render_cell_value = require("../common/render_cell_value");
var _get_columns = require("../common/get_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsPageTableConfiguration = (observabilityRuleTypeRegistry, config) => {
  const renderCustomActionsRow = props => {
    return /*#__PURE__*/_react.default.createElement(_alert_actions.AlertActions, (0, _extends2.default)({}, props, {
      config: config,
      observabilityRuleTypeRegistry: observabilityRuleTypeRegistry
    }));
  };
  return {
    id: _common.observabilityFeatureId,
    cases: {
      featureId: _common.casesFeatureId,
      owner: [_common.observabilityFeatureId]
    },
    columns: (0, _get_columns.getColumns)({
      showRuleName: true
    }),
    getRenderCellValue: _render_cell_value.getRenderCellValue,
    sort: [{
      [_ruleDataUtils.ALERT_START]: {
        order: 'desc'
      }
    }],
    useActionsColumn: () => ({
      renderCustomActionsRow
    }),
    useInternalFlyout: () => {
      const {
        header,
        body,
        footer
      } = (0, _use_get_alert_flyout_components.useGetAlertFlyoutComponents)(observabilityRuleTypeRegistry);
      return {
        header,
        body,
        footer
      };
    },
    ruleTypeIds: observabilityRuleTypeRegistry.list(),
    showInspectButton: true
  };
};
exports.getAlertsPageTableConfiguration = getAlertsPageTableConfiguration;