"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "AlertsFlyout", {
  enumerable: true,
  get: function () {
    return _alerts_flyout.AlertsFlyout;
  }
});
exports.useGetAlertFlyoutComponents = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/observability-shared-plugin/common");
var _paths = require("../../../common/locators/paths");
var _alerts_flyout_header = require("./alerts_flyout_header");
var _alerts_flyout_body = require("./alerts_flyout_body");
var _alerts_flyout_footer = require("./alerts_flyout_footer");
var _parse_alert = require("../../pages/alerts/helpers/parse_alert");
var _alerts_flyout = require("./alerts_flyout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAlertFlyoutComponents = observabilityRuleTypeRegistry => {
  const isSLODetailsPage = (0, _reactRouterDom.useRouteMatch)(_paths.SLO_DETAIL_PATH);
  const body = (0, _react.useCallback)(props => {
    const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(props.alert);
    return /*#__PURE__*/_react.default.createElement(_alerts_flyout_body.AlertsFlyoutBody, {
      alert: alert,
      rawAlert: props.alert,
      id: props.id
    });
  }, [observabilityRuleTypeRegistry]);
  const header = (0, _react.useCallback)(props => {
    const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(props.alert);
    return /*#__PURE__*/_react.default.createElement(_alerts_flyout_header.AlertsFlyoutHeader, {
      alert: alert
    });
  }, [observabilityRuleTypeRegistry]);
  const footer = (0, _react.useCallback)(props => {
    const isInApp = Boolean(_common.SLO_ALERTS_TABLE_ID === props.id && isSLODetailsPage);
    const alert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(props.alert);
    return /*#__PURE__*/_react.default.createElement(_alerts_flyout_footer.AlertsFlyoutFooter, {
      isInApp: isInApp,
      alert: alert
    });
  }, [isSLODetailsPage, observabilityRuleTypeRegistry]);
  return (0, _react.useMemo)(() => ({
    body,
    header,
    footer
  }), [body, header, footer]);
};
exports.useGetAlertFlyoutComponents = useGetAlertFlyoutComponents;