"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAlertSearchBar = ObservabilityAlertSearchBar;
exports.default = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
var _components = require("./components");
var _constants = require("../../../common/constants");
var _constants2 = require("./constants");
var _build_es_query = require("../../utils/build_es_query");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertStatusQuery = status => {
  return _constants2.ALERT_STATUS_QUERY[status] ? [{
    query: _constants2.ALERT_STATUS_QUERY[status],
    language: 'kuery'
  }] : [];
};
const toastTitle = _i18n.i18n.translate('xpack.observability.alerts.searchBar.invalidQueryTitle', {
  defaultMessage: 'Invalid query string'
});
const defaultFilters = [];
function ObservabilityAlertSearchBar({
  appName,
  defaultSearchQueries = _constants2.DEFAULT_QUERIES,
  onEsQueryChange,
  onKueryChange,
  onRangeFromChange,
  onRangeToChange,
  onStatusChange,
  onFiltersChange,
  showFilterBar = false,
  filters = defaultFilters,
  savedQuery,
  setSavedQuery,
  kuery,
  rangeFrom,
  rangeTo,
  services: {
    AlertsSearchBar,
    timeFilterService,
    useToasts,
    uiSettings
  },
  status
}) {
  const toasts = useToasts();
  const clearSavedQuery = (0, _react.useCallback)(() => setSavedQuery ? setSavedQuery(undefined) : null, [setSavedQuery]);
  const onAlertStatusChange = (0, _react.useCallback)(alertStatus => {
    try {
      onEsQueryChange((0, _build_es_query.buildEsQuery)({
        timeRange: {
          to: rangeTo,
          from: rangeFrom
        },
        kuery,
        queries: [...getAlertStatusQuery(alertStatus), ...defaultSearchQueries],
        config: (0, _common.getEsQueryConfig)(uiSettings)
      }));
    } catch (error) {
      toasts.addError(error, {
        title: toastTitle
      });
      onKueryChange(_constants2.DEFAULT_QUERY_STRING);
    }
  }, [onEsQueryChange, rangeTo, rangeFrom, kuery, defaultSearchQueries, uiSettings, toasts, onKueryChange]);
  (0, _react.useEffect)(() => {
    onAlertStatusChange(status);
  }, [onAlertStatusChange, status]);
  const submitQuery = (0, _react.useCallback)(() => {
    try {
      onEsQueryChange((0, _build_es_query.buildEsQuery)({
        timeRange: {
          to: rangeTo,
          from: rangeFrom
        },
        kuery,
        queries: [...getAlertStatusQuery(status), ...defaultSearchQueries],
        filters,
        config: (0, _common.getEsQueryConfig)(uiSettings)
      }));
    } catch (error) {
      toasts.addError(error, {
        title: toastTitle
      });
      onKueryChange(_constants2.DEFAULT_QUERY_STRING);
    }
  }, [defaultSearchQueries, filters, kuery, onEsQueryChange, onKueryChange, rangeFrom, rangeTo, status, uiSettings, toasts]);
  (0, _react.useEffect)(() => {
    submitQuery();
  }, [submitQuery]);
  const onQuerySubmit = ({
    dateRange,
    query
  }, isUpdate) => {
    if (isUpdate) {
      clearSavedQuery();
      onKueryChange(query !== null && query !== void 0 ? query : '');
      timeFilterService.setTime(dateRange);
      onRangeFromChange(dateRange.from);
      onRangeToChange(dateRange.to);
    } else {
      submitQuery();
    }
  };
  const onFilterUpdated = (0, _react.useCallback)(updatedFilters => {
    clearSavedQuery();
    onFiltersChange === null || onFiltersChange === void 0 ? void 0 : onFiltersChange(updatedFilters);
  }, [clearSavedQuery, onFiltersChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsSearchBar, {
    appName: appName,
    featureIds: _constants.observabilityAlertFeatureIds,
    rangeFrom: rangeFrom,
    rangeTo: rangeTo,
    showFilterBar: showFilterBar,
    filters: filters,
    onFiltersUpdated: onFilterUpdated,
    savedQuery: savedQuery,
    onSavedQueryUpdated: setSavedQuery,
    onClearSavedQuery: clearSavedQuery,
    query: kuery,
    onQuerySubmit: onQuerySubmit
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_components.AlertsStatusFilter, {
    status: status,
    onChange: onStatusChange
  })))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = ObservabilityAlertSearchBar;